/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emt4j.common.DependTarget;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.JdkMigrationException;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.staticanalysis.StaticAnalysisEntry;
import org.eclipse.emt4j.common.util.FileUtil;
import org.mvel2.MVEL;

@RuleImpl(type="whole-class")
public class WholeClassRule
extends ExecutableRule {
    private String mvel2RuleFile;
    private String mvel2Rule;
    private String staticAnalysisRule;

    public WholeClassRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        this.mvel2Rule = String.join((CharSequence)" ", FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.mvel2RuleFile, false));
    }

    @Override
    protected CheckResult check(Dependency dependency) {
        HashMap<String, Set<String>> mvelMap = new HashMap<String, Set<String>>();
        mvelMap.put("typeSet", dependency.getClassSymbol().getTypeSet());
        mvelMap.put("methodSet", this.toMethodIdentifierSet(dependency.getClassSymbol().getCallMethodSet()));
        mvelMap.put("cpSet", dependency.getClassSymbol().getConstantPoolSet());
        Object result = MVEL.eval((String)this.mvel2Rule, mvelMap);
        if (result instanceof Boolean) {
            if (this.staticAnalysisRule == null) {
                return (Boolean)result != false ? CheckResult.FAIL : CheckResult.PASS;
            }
            if (((Boolean)result).booleanValue()) {
                boolean found = StaticAnalysisEntry.analyze(this.staticAnalysisRule, dependency.getTarget().asClass().getClassName(), dependency.getCurrClassBytecode());
                return found ? CheckResult.FAIL : CheckResult.PASS;
            }
            return CheckResult.PASS;
        }
        throw new JdkMigrationException("Mvel2 rule file" + this.mvel2RuleFile + " must return a boolean result!Now result type is : " + result.getClass());
    }

    private Set<String> toMethodIdentifierSet(Set<DependTarget.Method> callMethodSet) {
        if (callMethodSet == null || callMethodSet.isEmpty()) {
            return Collections.emptySet();
        }
        return callMethodSet.stream().map(m -> m.toMethodIdentifierNoDesc()).collect(Collectors.toSet());
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.WHOLE_CLASS == dependency.getDependType();
    }

    public void setMvel2RuleFile(String mvel2RuleFile) {
        this.mvel2RuleFile = mvel2RuleFile;
    }

    public void setMvel2Rule(String mvel2Rule) {
        this.mvel2Rule = mvel2Rule;
    }

    public void setStaticAnalysisRule(String staticAnalysisRule) {
        this.staticAnalysisRule = staticAnalysisRule;
    }
}

