/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emt4j.common.Dependency;

public class CheckResult
implements Serializable {
    private boolean pass;
    private Map<String, Object> context;
    public static final CheckResult PASS = new CheckResult(true);
    public static final CheckResult FAIL = new CheckResult(false);
    public transient List<Dependency> propagated = new ArrayList<Dependency>();

    public CheckResult(boolean pass, Map<String, Object> context) {
        this.pass = pass;
        this.context = context;
    }

    public CheckResult(boolean pass) {
        this.pass = pass;
    }

    public CheckResult() {
    }

    public boolean isPass() {
        return this.pass;
    }

    public void setPass(boolean pass) {
        this.pass = pass;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public static CheckResult pass() {
        return new CheckResult(true);
    }

    public static CheckResult pass(String key, Object value) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(key, value);
        return new CheckResult(true, context);
    }

    public static CheckResult pass(Map<String, Object> context) {
        return new CheckResult(true, context);
    }

    public static CheckResult fail() {
        return new CheckResult(false);
    }

    public static CheckResult fail(String key, Object value) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(key, value);
        return new CheckResult(false, context);
    }

    public static CheckResult fail(Map<String, Object> context) {
        return new CheckResult(false, context);
    }

    public List<Dependency> getPropagated() {
        return this.propagated;
    }

    public void setPropagated(List<Dependency> propagated) {
        this.propagated = propagated;
    }
}

