/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.staticanalysis;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.emt4j.common.JdkMigrationException;
import org.eclipse.emt4j.common.staticanalysis.Invoker;

public class StaticAnalysisEntry {
    private static final ThreadLocal<Invoker> INVOKER = ThreadLocal.withInitial(() -> {
        try {
            SootAnalysisClassLoader sootAnalysisClassLoader;
            ClassLoader classLoader = StaticAnalysisEntry.class.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                sootAnalysisClassLoader = new SootAnalysisClassLoader(urlClassLoader.getURLs(), (ClassLoader)urlClassLoader);
            } else {
                String[] cps = System.getProperty("java.class.path").split(File.pathSeparator);
                URL[] urls = new URL[cps.length];
                for (int i = 0; i < cps.length; ++i) {
                    urls[i] = new File(cps[i]).toURI().toURL();
                }
                sootAnalysisClassLoader = new SootAnalysisClassLoader(urls, classLoader);
            }
            Class<?> clazz = sootAnalysisClassLoader.loadClass("org.eclipse.emt4j.common.staticanalysis.InvokerImpl");
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Invoker)constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new JdkMigrationException(t);
        }
    });

    public static boolean analyze(String rule, String className, byte[] bytecodes) {
        return INVOKER.get().invoke(rule, className, bytecodes);
    }

    static class SootAnalysisClassLoader
    extends URLClassLoader {
        public SootAnalysisClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith(Invoker.class.getPackage().getName()) && !name.endsWith("Invoker") || name.startsWith("soot.")) {
                Class<?> loaded = this.findLoadedClass(name);
                return loaded != null ? loaded : super.findClass(name);
            }
            return super.loadClass(name);
        }
    }
}

