/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.staticanalysis.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emt4j.common.staticanalysis.Analyzer;
import soot.Body;
import soot.Local;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.CastExpr;
import soot.jimple.JimpleBody;
import soot.jimple.StaticFieldRef;
import soot.jimple.internal.JAssignStmt;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;

abstract class BaseAnalyzer
implements Analyzer {
    BaseAnalyzer() {
    }

    @Override
    public boolean analyze(SootClass clazz) {
        for (SootMethod method : clazz.getMethods()) {
            if (method.isAbstract() || !this.doAnalyze(method)) continue;
            return true;
        }
        return false;
    }

    abstract boolean doAnalyze(SootMethod var1);

    protected static final Set<Value> getDefValues(SimpleLocalDefs localDefs, Unit unit, Local local) {
        HashSet<Value> values = new HashSet<Value>();
        List defs = localDefs.getDefsOfAt(local, unit);
        for (Unit def : defs) {
            if (!(def instanceof JAssignStmt)) continue;
            JAssignStmt assign = (JAssignStmt)def;
            Value rightOp = assign.getRightOp();
            if (rightOp instanceof Local) {
                values.addAll(BaseAnalyzer.getDefValues(localDefs, def, (Local)rightOp));
                continue;
            }
            if (rightOp instanceof CastExpr) {
                values.addAll(BaseAnalyzer.getDefValues(localDefs, def, (Local)((CastExpr)rightOp).getOp()));
                continue;
            }
            if (rightOp instanceof StaticFieldRef) {
                StaticFieldRef ref = (StaticFieldRef)rightOp;
                values.addAll(BaseAnalyzer.globalTarget(ref));
                continue;
            }
            values.add(rightOp);
        }
        return values;
    }

    protected static final Set<Unit> getDefUnits(SimpleLocalDefs localDefs, Unit unit, Local local) {
        HashSet<Unit> units = new HashSet<Unit>();
        List defs = localDefs.getDefsOfAt(local, unit);
        for (Unit def : defs) {
            units.add(def);
            if (!(def instanceof JAssignStmt)) continue;
            JAssignStmt assign = (JAssignStmt)def;
            Value rightOp = assign.getRightOp();
            if (rightOp instanceof Local) {
                units.addAll(BaseAnalyzer.getDefUnits(localDefs, def, (Local)rightOp));
                continue;
            }
            if (!(rightOp instanceof CastExpr)) continue;
            units.addAll(BaseAnalyzer.getDefUnits(localDefs, def, (Local)((CastExpr)rightOp).getOp()));
        }
        return units;
    }

    private static Set<Value> globalTarget(StaticFieldRef fieldRef) {
        SootClass declaringClass = fieldRef.getField().getDeclaringClass();
        SootMethod method = declaringClass.getMethodByName("<clinit>");
        JimpleBody body = (JimpleBody)method.retrieveActiveBody();
        Local targetLocal = null;
        Unit targetUnit = null;
        for (Unit unit : body.getUnits()) {
            JAssignStmt assignStmt;
            if (!(unit instanceof JAssignStmt) || !(assignStmt = (JAssignStmt)unit).getLeftOp().equivTo((Object)fieldRef)) continue;
            if (assignStmt.getRightOp() instanceof Local) {
                targetLocal = (Local)assignStmt.getRightOp();
            }
            targetUnit = unit;
            break;
        }
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph((Body)body);
        SimpleLocalDefs localDefs = new SimpleLocalDefs((UnitGraph)graph);
        return BaseAnalyzer.getDefValues(localDefs, targetUnit, targetLocal);
    }
}

