/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.emt4j.analysis.AnalysisMain;
import org.eclipse.emt4j.analysis.common.util.ProcessUtil;
import org.eclipse.emt4j.analysis.common.util.ZipUtil;
import org.eclipse.emt4j.plugin.BaseMojo;

abstract class BaseCheckMojo
extends BaseMojo {
    @Parameter(property="outputFormat", defaultValue="HTML")
    protected String outputFormat;
    @Parameter(property="outputFile", defaultValue="report.html")
    protected String outputFile;
    @Parameter(property="externalToolHome")
    protected String externalToolHome;
    @Parameter(property="targetJDKHome")
    protected String targetJDKHome;
    @Parameter(property="externalTools")
    protected List<String> externalTools;

    BaseCheckMojo() {
    }

    @Override
    void doExecute() throws MojoExecutionException {
        try {
            if (this.preCheck()) {
                this.check();
            }
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t.getMessage(), t);
        }
    }

    boolean preCheck() throws Exception {
        return true;
    }

    void check() throws Exception {
        this.prepareExternalTools();
        AnalysisMain.main((String[])this.buildArgs(this.resolveOutputFile(), this.outputFormat));
    }

    abstract List<String> getCheckTargets();

    private void prepareExternalTools() throws MojoFailureException, MojoExecutionException {
        if (this.externalTools != null && !this.externalTools.isEmpty()) {
            Path localRepoPath = Paths.get(this.session.getRequest().getLocalRepositoryPath().toURI());
            if (this.externalToolHome == null || this.externalToolHome.length() == 0) {
                throw new MojoFailureException("There is no available external tool home set. Please set with -DexternalToolHome= in your mvn command line or <externalToolHome> in pom.");
            }
            for (String externalTool : this.externalTools) {
                Path externalToolHomePath = Paths.get(this.externalToolHome, new String[0]);
                Path toolPath = externalToolHomePath.resolve(externalTool.replace(":", "-"));
                try {
                    Path artifactPath;
                    if (!Files.notExists(toolPath, new LinkOption[0]) && !Files.list(toolPath).findAny().isPresent()) continue;
                    ArrayList<String> command = new ArrayList<String>();
                    String mvnHome = System.getProperty("maven.home");
                    if (mvnHome == null) {
                        throw new MojoFailureException("System property maven.home is not set. This plugin should be called from mvn command line.");
                    }
                    Path mvnPath = Paths.get(mvnHome, new String[0]).resolve("bin").resolve("mvn");
                    if (Files.notExists(mvnPath, new LinkOption[0])) {
                        throw new MojoFailureException("Can't find mvn executable file " + mvnPath);
                    }
                    command.add(mvnPath.toString());
                    command.add("dependency:get");
                    command.add("-Dartifact=" + externalTool);
                    command.add("-s");
                    command.add(this.session.getRequest().getUserSettingsFile().toString());
                    try {
                        int ret = ProcessUtil.noBlockingRun(command);
                        if (ret != 0) {
                            throw new MojoFailureException("Fail to download required external tool:" + externalTool);
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        throw new MojoFailureException("Fail to download required external tool:" + externalTool, (Throwable)e);
                    }
                    String[] tokens = externalTool.split(":");
                    String groupId = tokens[0];
                    String artifactId = tokens[1];
                    String version = tokens[2];
                    String type = "jar";
                    String classifier = null;
                    if (tokens.length >= 4) {
                        type = tokens[3];
                    }
                    if (tokens.length == 5) {
                        classifier = tokens[4];
                    }
                    if (Files.exists(artifactPath = localRepoPath.resolve(groupId.replace(".", File.separator)).resolve(artifactId).resolve(version).resolve(artifactId + "-" + version + "-" + (classifier == null ? "" : classifier) + "." + type), new LinkOption[0])) {
                        if (type.equals("jar")) {
                            Files.copy(artifactPath, toolPath.resolve(artifactPath.getFileName()), new CopyOption[0]);
                            continue;
                        }
                        if (!type.equals("zip")) continue;
                        ZipUtil.unzipTo((Path)artifactPath, (Path)toolPath);
                        continue;
                    }
                    throw new MojoExecutionException("The external tool " + artifactPath + " doesn't exist.");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed when checking existed external tool directory.", (Exception)e);
                }
            }
        }
    }

    private File resolveOutputFile() {
        Path path;
        if (this.outputFile != null && (path = Paths.get(this.outputFile, new String[0])).isAbsolute()) {
            return new File(this.outputFile);
        }
        File dir = new File(this.session.getExecutionRootDirectory());
        if (this.outputFile == null) {
            this.outputFile = "report." + (this.outputFormat == null ? "html" : this.outputFormat);
        }
        return new File(dir, this.outputFile);
    }

    private String[] buildArgs(File output, String format) {
        ArrayList<String> args = new ArrayList<String>();
        this.param(args, "-f", String.valueOf(this.fromVersion));
        this.param(args, "-t", String.valueOf(this.toVersion));
        this.param(args, "-p", format);
        this.param(args, "-o", output.getAbsolutePath());
        this.param(args, "-e", this.externalToolHome);
        if (this.targetJDKHome != null) {
            this.param(args, "-j", this.targetJDKHome);
        }
        if (this.verbose) {
            args.add("-v");
        }
        if (this.priority != null) {
            this.param(args, "-priority", this.priority);
        }
        args.addAll(this.getCheckTargets());
        return args.toArray(new String[0]);
    }

    private void param(List<String> args, String k, String v) {
        if (v != null && !"".equals(v)) {
            args.add(k);
            args.add(v);
        }
    }
}

