/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.eclipse.emt4j.plugin.BaseCheckMojo;

@Mojo(name="check", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class CheckMojo
extends BaseCheckMojo {
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    private File configFile;
    private File modulesFile;
    private File dependenciesFile;
    private final List<String> modules = new ArrayList<String>();
    private final List<String> dependencies = new ArrayList<String>();

    @Override
    boolean preCheck() throws Exception {
        List projects = this.session.getProjects();
        this.initFiles();
        if (this.project.equals(projects.get(0))) {
            this.prepare();
        } else {
            this.load();
        }
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProject(this.project);
        DependencyNode root = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, artifact -> true);
        this.addModule(root);
        return this.project.equals(projects.get(projects.size() - 1));
    }

    @Override
    List<String> getCheckTargets() {
        ArrayList<String> targets = new ArrayList<String>();
        targets.add(this.configFile.getAbsolutePath());
        List projects = this.session.getProjects();
        for (MavenProject project : projects) {
            File file = new File(project.getBuild().getDirectory(), "emt4j.dat");
            if (!file.exists() || file.isDirectory()) continue;
            System.out.println(file.getAbsolutePath());
            targets.add(file.getAbsolutePath());
        }
        return targets;
    }

    private void initFiles() {
        this.configFile = new File(this.session.getExecutionRootDirectory(), ".emt4j");
        this.modulesFile = new File(this.configFile, "modules");
        this.dependenciesFile = new File(this.configFile, "dependencies");
    }

    private void prepare() throws IOException {
        if (this.configFile.exists()) {
            Files.walk(this.configFile.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        this.configFile.mkdir();
        this.modulesFile.createNewFile();
        this.dependenciesFile.createNewFile();
    }

    private void load() throws IOException {
        String[] pair;
        String str;
        this.modules.clear();
        this.dependencies.clear();
        BufferedReader br = Files.newBufferedReader(this.modulesFile.toPath());
        while ((str = br.readLine()) != null) {
            pair = str.split("=");
            this.modules.add(pair[0]);
        }
        br.close();
        br = Files.newBufferedReader(this.dependenciesFile.toPath());
        while ((str = br.readLine()) != null) {
            pair = str.split("=");
            this.dependencies.add(pair[0]);
        }
        br.close();
    }

    private String keyOf(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    private void addModule(DependencyNode root) throws IOException {
        String testOutputDirectory;
        Artifact artifact = root.getArtifact();
        String key = this.keyOf(artifact);
        if (this.modules.contains(key)) {
            return;
        }
        StringBuilder outputs = new StringBuilder();
        String outputDirectory = this.project.getBuild().getOutputDirectory();
        if (new File(outputDirectory).exists()) {
            outputs.append(outputDirectory);
        }
        if (new File(testOutputDirectory = this.project.getBuild().getTestOutputDirectory()).exists()) {
            if (outputs.length() > 0) {
                outputs.append(File.pathSeparatorChar);
            }
            outputs.append(testOutputDirectory);
        }
        if (outputs.length() > 0) {
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.modulesFile.toPath(), StandardOpenOption.APPEND), StandardCharsets.UTF_8));){
                bw.write(key + "=" + outputs);
                bw.newLine();
            }
        }
        this.addDependencies(root);
    }

    private void addDependencies(DependencyNode root) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.dependenciesFile.toPath(), StandardOpenOption.APPEND), StandardCharsets.UTF_8));){
            this.addDependencies(root, bw);
        }
    }

    private void addDependencies(DependencyNode node, BufferedWriter bw) throws IOException {
        List children = node.getChildren();
        if (children == null) {
            return;
        }
        for (DependencyNode child : children) {
            Artifact artifact = child.getArtifact();
            String key = this.keyOf(artifact);
            if (this.dependencies.contains(key) || this.modules.contains(key)) continue;
            ArtifactRepository localRepository = this.session.getLocalRepository();
            bw.write(key + "=" + new File(localRepository.getBasedir(), localRepository.pathOf(artifact)).getAbsolutePath());
            bw.newLine();
            this.addDependencies(child, bw);
        }
    }
}

