/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.plugin;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.emt4j.plugin.BaseMojo;

@Mojo(name="inject-agent", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class InjectAgentMojo
extends BaseMojo {
    @Parameter(defaultValue="${project.build.directory}/emt4j.dat", required=true, readonly=true)
    private File dat;
    @Parameter(property="plugin.artifactMap", required=true, readonly=true)
    Map<String, Artifact> pluginArtifactMap;

    @Override
    void doExecute() {
        String key = "argLine";
        Properties properties = this.project.getProperties();
        StringBuilder fv = new StringBuilder();
        String original = properties.getProperty(key);
        if (original != null) {
            fv.append(original);
        }
        fv.append(" ").append(this.buildAgentOption());
        this.project.getProperties().setProperty("argLine", fv.toString());
    }

    private String agentPath() {
        return this.pluginArtifactMap.get("org.eclipse.emt4j:emt4j-agent-jdk" + this.fromVersion).getFile().getAbsolutePath();
    }

    private String buildAgentOption() {
        StringBuilder opt = new StringBuilder();
        opt.append("-javaagent:").append(this.agentPath()).append('=').append("to=").append(this.toVersion).append(',').append("file=").append(this.dat.getAbsolutePath());
        if (this.priority != null && !this.priority.isEmpty()) {
            opt.append(',').append("priority=").append(this.priority);
        }
        return opt.toString();
    }
}

