/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.ecl.concurrent.EclModuleParallel;
import org.eclipse.epsilon.ecl.dom.MatchRule;
import org.eclipse.epsilon.ecl.execute.context.concurrent.EclContextParallel;
import org.eclipse.epsilon.ecl.execute.context.concurrent.IEclContextParallel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.erl.concurrent.IErlModuleParallelAnnotation;

public class EclModuleParallelAnnotation
extends EclModuleParallel
implements IErlModuleParallelAnnotation {
    public EclModuleParallelAnnotation() {
    }

    public EclModuleParallelAnnotation(IEclContextParallel context) {
        super(context);
    }

    @Override
    protected void matchAllRules(boolean greedy) throws EolRuntimeException {
        boolean ofTypeOnly = !greedy;
        EclContextParallel context = (EclContextParallel)this.getContext();
        for (MatchRule matchRule : this.getMatchRules()) {
            if (matchRule.isAbstract((IEolContext)context) || matchRule.isLazy((IEolContext)context) || !ofTypeOnly && !matchRule.isGreedy((IEolContext)context)) continue;
            Collection<?> leftInstances = matchRule.getLeftInstances(context, ofTypeOnly);
            if (matchRule.getBooleanAnnotationValue("parallel", (IEolContext)context, () -> new Variable[]{Variable.createReadOnlyVariable((String)"leftInstances", (Object)leftInstances), Variable.createReadOnlyVariable((String)"matchRule", (Object)((Object)matchRule)), Variable.createReadOnlyVariable((String)"THREADS", (Object)context.getParallelism())})) {
                ArrayList<Callable<Object>> jobs = new ArrayList<Callable<Object>>(leftInstances.size() * leftInstances.size());
                for (Object left : leftInstances) {
                    Collection<?> rightInstances = matchRule.isRightDomainDynamic() ? matchRule.getRightInstances(context, ofTypeOnly, left) : matchRule.getRightInstances(context, ofTypeOnly);
                    for (Object right : rightInstances) {
                        jobs.add(() -> matchRule.matchPair(context.getShadow(), ofTypeOnly, left, right));
                    }
                }
                context.executeAll((ModuleElement)matchRule, jobs);
                continue;
            }
            for (Object left : leftInstances) {
                Collection<?> rightInstances = matchRule.isRightDomainDynamic() ? matchRule.getRightInstances(context, ofTypeOnly, left) : matchRule.getRightInstances(context, ofTypeOnly);
                for (Object right : rightInstances) {
                    matchRule.matchPair(context, ofTypeOnly, left, right);
                }
            }
        }
    }
}

