/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl.dom;

import java.util.Collection;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.ecl.dom.IEclVisitor;
import org.eclipse.epsilon.ecl.exceptions.EclNotApplicableSuperRuleException;
import org.eclipse.epsilon.ecl.execute.context.IEclContext;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.ecl.trace.MatchTrace;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.erl.dom.ExtensibleNamedRule;

public class MatchRule
extends ExtensibleNamedRule {
    protected ExecutableBlock<Boolean> compareBlock;
    protected ExecutableBlock<Boolean> guardBlock;
    protected ExecutableBlock<Void> doBlock;
    protected ExecutableBlock<Collection<?>> leftDomainBlock;
    protected ExecutableBlock<Collection<?>> rightDomainBlock;
    protected Parameter leftParameter;
    protected Parameter rightParameter;

    public AST getSuperRulesAst(AST cst) {
        return AstUtil.getChild((AST)cst, (int)85);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.leftDomainBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)90), (ModuleElement)this);
        this.rightDomainBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)91), (ModuleElement)this);
        this.leftParameter = (Parameter)module.createAst(cst.getSecondChild(), (ModuleElement)this);
        this.rightParameter = this.leftDomainBlock == null ? (Parameter)module.createAst(cst.getThirdChild(), (ModuleElement)this) : (Parameter)module.createAst(cst.getFourthChild(), (ModuleElement)this);
        this.compareBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)88), (ModuleElement)this);
        this.doBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)89), (ModuleElement)this);
        this.guardBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)86), (ModuleElement)this);
    }

    public boolean appliesTo(Object left, Object right, IEclContext context, boolean ofTypeOnly) throws EolRuntimeException {
        boolean oto = ofTypeOnly && !this.isGreedy((IEolContext)context);
        boolean appliesToTypes = this.getAllInstances(this.leftParameter, (IEolContext)context, oto).contains(left) && this.getAllInstances(this.rightParameter, (IEolContext)context, oto).contains(right);
        boolean guardSatisfied = !this.isAbstract((IEolContext)context) && appliesToTypes && this.guardBlock != null ? (Boolean)this.guardBlock.execute((IEolContext)context, new Variable[]{Variable.createReadOnlyVariable((String)this.leftParameter.getName(), (Object)left), Variable.createReadOnlyVariable((String)this.rightParameter.getName(), (Object)right), Variable.createReadOnlyVariable((String)"self", (Object)((Object)this))}) : true;
        return appliesToTypes && guardSatisfied;
    }

    public Collection<?> getLeftInstances(IEclContext context, boolean ofTypeOnly) throws EolRuntimeException {
        if (this.leftDomainBlock == null) {
            return this.getAllInstances(this.leftParameter, (IEolContext)context, ofTypeOnly);
        }
        return (Collection)this.leftDomainBlock.execute((IEolContext)context, true, new Variable[0]);
    }

    public Collection<?> getRightInstances(IEclContext context, boolean ofTypeOnly) throws EolRuntimeException {
        if (this.rightDomainBlock == null) {
            return this.getAllInstances(this.rightParameter, (IEolContext)context, ofTypeOnly);
        }
        return (Collection)this.rightDomainBlock.execute((IEolContext)context, true, new Variable[0]);
    }

    public Collection<?> getRightInstances(IEclContext context, boolean ofTypeOnly, Object left) throws EolRuntimeException {
        if (this.rightDomainBlock == null) {
            return this.getAllInstances(this.rightParameter, (IEolContext)context, ofTypeOnly);
        }
        if (this.rightDomainBlock.getText().equals("from")) {
            FrameStack scope = context.getFrameStack();
            scope.enterLocal(FrameType.PROTECTED, (ModuleElement)this, new Variable[0]);
            scope.put(Variable.createReadOnlyVariable((String)this.leftParameter.getName(), (Object)left));
        }
        return (Collection)this.rightDomainBlock.execute((IEolContext)context, true, new Variable[0]);
    }

    public Match matchPair(IEclContext context, boolean ofTypeOnly, Object leftInstance, Object rightInstance) throws EolRuntimeException {
        if (!ofTypeOnly && context.getMatchTrace().getMatch(leftInstance, rightInstance) != null) {
            return null;
        }
        if (this.appliesTo(leftInstance, rightInstance, context, true)) {
            return this.match(leftInstance, rightInstance, context, null, false);
        }
        if (this.appliesTo(leftInstance, rightInstance, context, false)) {
            return this.match(leftInstance, rightInstance, context, null, false);
        }
        return null;
    }

    public Match match(Object left, Object right, IEclContext context, EolMap<?, ?> matchInfo, boolean forcedMatch) throws EolRuntimeException {
        boolean asSuperRule;
        MatchTrace matchTrace = context.getMatchTrace();
        MatchTrace tempMatchTrace = context.getTempMatchTrace();
        Match match = null;
        Match tempMatch = null;
        boolean bl = asSuperRule = matchInfo != null;
        if (!asSuperRule) {
            tempMatch = tempMatchTrace.getMatch(left, right);
            if (tempMatch != null) {
                return tempMatch;
            }
            tempMatch = new Match(left, right, true, this);
            tempMatchTrace.add(tempMatch);
            match = matchTrace.getMatch(left, right);
            if (match != null) {
                tempMatchTrace.remove(tempMatch);
                return match;
            }
        } else if (!this.appliesTo(left, right, context, false)) {
            throw new EclNotApplicableSuperRuleException(left, right, this, context);
        }
        match = new Match(left, right, true, this);
        if (!this.superRules.isEmpty()) {
            boolean matching = true;
            for (ExtensibleNamedRule rule : this.superRules) {
                MatchRule matchRule = (MatchRule)rule;
                Match superRuleMatch = matchRule.match(left, right, context, match.getInfo(), false);
                boolean bl2 = matching = matching && superRuleMatch.isMatching();
            }
            match.setMatching(matching);
            if (!matching) {
                tempMatchTrace.remove(tempMatch);
                matchTrace.add(match);
                return match;
            }
        }
        FrameStack scope = context.getFrameStack();
        scope.enterLocal(FrameType.PROTECTED, (ModuleElement)this, new Variable[0]);
        EolMap<?, ?> info = asSuperRule ? matchInfo : match.getInfo();
        scope.put(new Variable[]{Variable.createReadOnlyVariable((String)this.leftParameter.getName(), (Object)left), Variable.createReadOnlyVariable((String)this.rightParameter.getName(), (Object)right), Variable.createReadOnlyVariable((String)"matchInfo", info), Variable.createReadOnlyVariable((String)"self", (Object)((Object)this))});
        if (this.compareBlock != null) {
            match.setMatching((Boolean)this.compareBlock.execute((IEolContext)context, false, new Variable[0]));
        } else if (this.superRules.isEmpty()) {
            match.setMatching(false);
        }
        if (!asSuperRule) {
            tempMatchTrace.remove(tempMatch);
            if (forcedMatch || tempMatchTrace.isEmpty()) {
                matchTrace.add(match);
            }
        }
        if (this.doBlock != null && match.isMatching()) {
            this.doBlock.execute((IEolContext)context, false, new Variable[0]);
        }
        scope.leaveLocal((ModuleElement)this);
        return match;
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getName(), this.leftParameter == null ? "(no left)" : this.leftParameter.getTypeName(), this.rightParameter == null ? "(no right)" : this.rightParameter.getTypeName());
    }

    public boolean isRightDomainDynamic() {
        return this.rightDomainBlock != null && this.rightDomainBlock.getText().equals("from");
    }

    public ExecutableBlock<Boolean> getCompareBlock() {
        return this.compareBlock;
    }

    public ExecutableBlock<Collection<?>> getLeftDomainBlock() {
        return this.leftDomainBlock;
    }

    public ExecutableBlock<Collection<?>> getRightDomainBlock() {
        return this.rightDomainBlock;
    }

    public Parameter getLeftParameter() {
        return this.leftParameter;
    }

    public Parameter getRightParameter() {
        return this.rightParameter;
    }

    public ExecutableBlock<Boolean> getGuardBlock() {
        return this.guardBlock;
    }

    public ExecutableBlock<Void> getDoBlock() {
        return this.doBlock;
    }

    public void accept(IEclVisitor visitor) {
        visitor.visit(this);
    }
}

