/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl.parse;

import java.util.Iterator;
import org.eclipse.epsilon.ecl.EclModule;
import org.eclipse.epsilon.ecl.dom.IEclVisitor;
import org.eclipse.epsilon.ecl.dom.MatchRule;
import org.eclipse.epsilon.eol.dom.Annotation;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.erl.parse.ErlUnparser;

public class EclUnparser
extends ErlUnparser
implements IEclVisitor {
    @Override
    public void visit(MatchRule matchRule) {
        if (matchRule.getAnnotationBlock() != null) {
            Iterator ann = matchRule.getAnnotationBlock().getAnnotations().iterator();
            while (ann.hasNext()) {
                this.buffer.append("@");
                this.buffer.append(((Annotation)ann.next()).getName());
                if (!ann.hasNext()) continue;
                this.comma();
            }
        }
        this.buffer.append("rule ");
        this.buffer.append(matchRule.getName());
        this.newline();
        this.buffer.append("match ");
        matchRule.getLeftParameter().accept((IEolVisitor)this);
        if (matchRule.getLeftDomainBlock() != null) {
            this.print("in", matchRule.getLeftDomainBlock());
        }
        this.newline();
        this.buffer.append("with ");
        matchRule.getRightParameter().accept((IEolVisitor)this);
        if (matchRule.getRightDomainBlock() != null) {
            if (matchRule.isRightDomainDynamic()) {
                this.print("from", matchRule.getRightDomainBlock());
            } else {
                this.print("in", matchRule.getRightDomainBlock());
            }
        }
        if (matchRule.getSuperRules().size() > 0) {
            this.buffer.append("extends ");
            Iterator li = matchRule.getSuperRules().iterator();
            while (li.hasNext()) {
                this.buffer.append(matchRule.getName());
                if (!li.hasNext()) continue;
                this.comma();
            }
        }
        this.spaceCurlybraceNewlineIndent();
        this.printGuard(matchRule.getGuardBlock());
        this.newline();
        this.print("compare", matchRule.getCompareBlock());
        this.newline();
        this.print("do", matchRule.getDoBlock());
        this.newlineUnindentCurlybrace();
    }

    protected void unparseRules() {
        ((EclModule)this.module).getDeclaredMatchRules().forEach(c -> {
            c.accept(this);
            this.newline();
        });
    }
}

