/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecl.trace;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.epsilon.ecl.dom.MatchRule;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class MatchTrace
implements Collection<Match> {
    protected MutableNetwork<Object, Match> _matchGraph;
    protected final AtomicLong creationCounter = new AtomicLong();
    protected final Map<Match, Long> matchOrder = new IdentityHashMap<Match, Long>();
    protected final boolean concurrent;
    protected String toStringCached;

    public MatchTrace() {
        this(false);
    }

    public MatchTrace(boolean concurrent) {
        this.concurrent = concurrent;
        this._matchGraph = this.createNetwork();
    }

    private MutableNetwork<Object, Match> createNetwork() {
        return NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).nodeOrder(ElementOrder.unordered()).edgeOrder(ElementOrder.insertion()).expectedNodeCount(1000).expectedEdgeCount(1000).build();
    }

    public MatchTrace(MatchTrace copy) {
        this.concurrent = Objects.requireNonNull(copy).concurrent;
        this.creationCounter.set(copy.creationCounter.get());
        this.matchOrder.putAll(copy.matchOrder);
        copy.syncOnGraph(graph -> {
            this._matchGraph = Graphs.copyOf(matchTrace._matchGraph);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T syncOnGraph(Function<MutableNetwork<Object, Match>, T> supplier) {
        if (this.concurrent) {
            MutableNetwork<Object, Match> mutableNetwork = this._matchGraph;
            synchronized (mutableNetwork) {
                return supplier.apply(this._matchGraph);
            }
        }
        return supplier.apply(this._matchGraph);
    }

    public MatchTrace getReduced() {
        return this.syncOnGraph(graph -> {
            MatchTrace reduced = new MatchTrace(this.concurrent);
            for (Match match : graph.edges()) {
                if (!match.isMatching()) continue;
                reduced.add(match);
            }
            return reduced;
        });
    }

    public Match add(Object left, Object right, boolean matching, MatchRule rule) {
        Match match = new Match(left, right, matching, rule);
        this.add(match);
        return match;
    }

    public Match getMatch(Object left, Object right) {
        return this.syncOnGraph(graph -> {
            Set nodes = graph.nodes();
            if (!nodes.contains(left) || !nodes.contains(right)) {
                return null;
            }
            Set edges = graph.edgesConnecting(left, right);
            return edges.isEmpty() ? null : Collections.min(edges, new MatchInsertionComparator());
        });
    }

    public Collection<Match> getMatches(Object object) {
        return this.syncOnGraph(graph -> {
            if (!graph.nodes().contains(object)) {
                return Collections.emptyList();
            }
            return graph.incidentEdges(object);
        });
    }

    public Match getMatch(Object object) {
        return this.syncOnGraph(graph -> {
            if (!graph.nodes().contains(object)) {
                return null;
            }
            ArrayList edges = new ArrayList(graph.incidentEdges(object));
            Collections.sort(edges, new MatchInsertionComparator());
            for (Match m : edges) {
                if (!m.isMatching()) continue;
                return m;
            }
            return null;
        });
    }

    public Match getMatch(Object left, MatchRule rule) {
        return this.syncOnGraph(graph -> {
            if (!graph.nodes().contains(left)) {
                return null;
            }
            ArrayList outEdges = new ArrayList(graph.outEdges(left));
            Collections.sort(outEdges, new MatchInsertionComparator());
            for (Match match : outEdges) {
                if (!match.isMatching() || match.getRule() != rule) continue;
                return match;
            }
            return null;
        });
    }

    public boolean hasBeenMatched(Object object) {
        return this.syncOnGraph(graph -> graph.nodes().contains(object));
    }

    public String toString(IEolContext context) {
        StringBuilder sb = new StringBuilder();
        this.syncOnGraph(graph -> {
            for (Match match : graph.edges()) {
                sb.append("[");
                sb.append(match.isMatching());
                sb.append("]\n");
                sb.append(context.getPrettyPrinterManager().toString(match.getLeft()));
                sb.append("\n ->");
                sb.append(context.getPrettyPrinterManager().toString(match.getRight()));
            }
            return null;
        });
        sb.append("\n-------------------------------------------");
        this.toStringCached = sb.toString();
        return this.toStringCached;
    }

    public Collection<Match> getMatches() {
        return this.syncOnGraph(graph -> graph.edges());
    }

    @Override
    public Stream<Match> stream() {
        return this.syncOnGraph(graph -> graph.edges().stream());
    }

    public String toString() {
        return this.toStringCached != null ? this.toStringCached : super.toString();
    }

    @Override
    public int hashCode() {
        return this.syncOnGraph(graph -> graph.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatchTrace other = (MatchTrace)obj;
        return this.syncOnGraph(myGraph -> other.syncOnGraph(otherGraph -> myGraph.equals(otherGraph)));
    }

    @Override
    public boolean add(Match match) {
        return this.syncOnGraph(graph -> this.internalAdd(match, (MutableNetwork<Object, Match>)graph));
    }

    private boolean internalAdd(Match match, MutableNetwork<Object, Match> graph) {
        boolean changed = graph.addEdge(match.getLeft(), match.getRight(), (Object)match);
        if (changed) {
            this.toStringCached = null;
            this.matchOrder.put(match, this.creationCounter.incrementAndGet());
        }
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Match)) {
            return false;
        }
        Match m = (Match)o;
        return this.syncOnGraph(graph -> this.internalRemove(m, (MutableNetwork<Object, Match>)graph));
    }

    private boolean internalRemove(Match m, MutableNetwork<Object, Match> graph) {
        boolean changed = graph.removeEdge((Object)m);
        if (changed) {
            this.toStringCached = null;
            this.matchOrder.remove(m);
        }
        return changed;
    }

    @Override
    public int size() {
        return this.syncOnGraph(graph -> graph.edges().size());
    }

    @Override
    public boolean isEmpty() {
        return this.syncOnGraph(graph -> graph.edges().isEmpty());
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Match)) {
            return false;
        }
        return this.syncOnGraph(graph -> graph.edges().contains(o));
    }

    @Override
    public Iterator<Match> iterator() {
        return this.syncOnGraph(graph -> graph.edges().iterator());
    }

    @Override
    public Object[] toArray() {
        return this.syncOnGraph(graph -> graph.edges().toArray());
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.syncOnGraph(graph -> graph.edges().toArray(a));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.syncOnGraph(graph -> graph.edges().containsAll(c));
    }

    @Override
    public boolean addAll(Collection<? extends Match> c) {
        return this.syncOnGraph(graph -> {
            boolean changed = false;
            for (Match m : c) {
                boolean bl = changed = this.internalAdd(m, (MutableNetwork<Object, Match>)graph) || changed;
            }
            return changed;
        });
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.syncOnGraph(graph -> {
            boolean ret = false;
            for (Object o : c) {
                if (!(o instanceof Match)) continue;
                Match m = (Match)o;
                boolean bl = ret = this.internalRemove(m, (MutableNetwork<Object, Match>)graph) || ret;
            }
            return ret;
        });
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.syncOnGraph(graph -> {
            boolean changed = this.matchOrder.keySet().retainAll(c);
            this._matchGraph = this.createNetwork();
            for (Match m : this.matchOrder.keySet()) {
                this._matchGraph.addEdge(m.getLeft(), m.getRight(), (Object)m);
            }
            return changed;
        });
    }

    @Override
    public void clear() {
        this.syncOnGraph(graph -> {
            this.toStringCached = null;
            this.matchOrder.clear();
            this._matchGraph = this.createNetwork();
            return null;
        });
    }

    @Override
    public Stream<Match> parallelStream() {
        return this.syncOnGraph(graph -> graph.edges().parallelStream());
    }

    private class MatchInsertionComparator
    implements Comparator<Match> {
        private MatchInsertionComparator() {
        }

        @Override
        public int compare(Match o1, Match o2) {
            Long l1 = MatchTrace.this.matchOrder.get(o1);
            Long l2 = MatchTrace.this.matchOrder.get(o2);
            if (l1 == null || l2 == null) {
                throw new IllegalStateException("A match not part of the network was compared");
            }
            return l1.compareTo(l2);
        }
    }
}

