/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.egl.EglPersistentTemplate;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.egl.formatter.NullFormatter;
import org.eclipse.epsilon.egl.incremental.IncrementalitySettings;
import org.eclipse.epsilon.egl.merge.output.LocatedRegion;
import org.eclipse.epsilon.egl.patch.Line;
import org.eclipse.epsilon.egl.patch.Patch;
import org.eclipse.epsilon.egl.patch.PatchValidationDiagnostic;
import org.eclipse.epsilon.egl.patch.TextBlock;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecificationFactory;
import org.eclipse.epsilon.egl.status.ProtectedRegionWarning;
import org.eclipse.epsilon.egl.traceability.OutputFile;
import org.eclipse.epsilon.egl.util.FileUtil;
import org.eclipse.epsilon.eol.IImportManager;
import org.eclipse.epsilon.eol.ImportManager;

public class EglFileGeneratingTemplate
extends EglPersistentTemplate {
    private File target;
    private String targetName;
    private OutputFile currentOutputFile;
    private String existingContents;
    private String newContents;
    private String positiveMessage;
    private OutputMode outputMode;

    protected EglFileGeneratingTemplate(URI path, IEglContext context, URI outputRoot) throws Exception {
        this(new EglTemplateSpecificationFactory(new NullFormatter(), new IncrementalitySettings(), (IImportManager)new ImportManager(), new ITemplateExecutionListener[0]).fromResource(path.toString(), path), context, outputRoot);
    }

    public EglFileGeneratingTemplate(EglTemplateSpecification spec, IEglContext context, URI outputRoot, String outputRootPath) throws Exception {
        super(spec, context, outputRoot, outputRootPath);
    }

    public EglFileGeneratingTemplate(EglTemplateSpecification spec, IEglContext context, URI outputRoot) throws Exception {
        super(spec, context, outputRoot);
    }

    public File append(String path) throws EglRuntimeException {
        return this.write(path, OutputMode.APPEND);
    }

    public File patch(String path) throws EglRuntimeException {
        return this.write(path, OutputMode.PATCH);
    }

    protected File write(String path, OutputMode outputMode) throws EglRuntimeException {
        try {
            File target = this.resolveFile(path);
            if (!this.isProcessed()) {
                this.process();
            }
            this.target = target;
            this.targetName = this.name(path);
            this.existingContents = FileUtil.readIfExists(target);
            this.outputMode = outputMode;
            this.prepareNewContents();
            this.writeNewContentsIfDifferentFromExistingContents();
            return target;
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + this.target, e, (ModuleElement)this.module);
        }
        catch (IOException ex) {
            throw new EglRuntimeException("Could not generate to: " + this.target, ex, (ModuleElement)this.module);
        }
    }

    @Override
    protected void doGenerate(File target, String targetName, boolean overwrite, boolean merge) throws EglRuntimeException {
        try {
            this.target = target;
            this.targetName = targetName;
            this.existingContents = FileUtil.readIfExists(target);
            this.outputMode = merge && target.exists() ? OutputMode.MERGE : OutputMode.WRITE;
            this.prepareNewContents();
            this.writeNewContentsIfDifferentFromExistingContents();
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + target, e, (ModuleElement)this.module);
        }
        catch (IOException ex) {
            throw new EglRuntimeException("Could not generate to: " + target, ex, (ModuleElement)this.module);
        }
    }

    protected void prepareNewContents() throws EglRuntimeException {
        switch (this.outputMode) {
            case APPEND: {
                this.newContents = this.getExistingContents() != null ? String.valueOf(this.getExistingContents()) + FileUtil.NEWLINE + this.getContents() : this.getContents();
                this.positiveMessage = "Successfully appended to ";
                break;
            }
            case MERGE: {
                this.newContents = this.merge(this.getExistingContents());
                this.positiveMessage = "Protected regions preserved in ";
                break;
            }
            case WRITE: {
                this.newContents = this.getContents();
                this.positiveMessage = "Successfully wrote to ";
                break;
            }
            case PATCH: {
                this.positiveMessage = "Successfully patched ";
                TextBlock existingContentsBlock = new TextBlock(this.getExistingContents().split(System.lineSeparator()));
                Patch patch = new Patch(this.getContents().split(System.lineSeparator()));
                List<PatchValidationDiagnostic> patchValidationDiagnostics = patch.validate();
                if (!patchValidationDiagnostics.isEmpty()) {
                    PatchValidationDiagnostic patchValidationDiagnostic = patchValidationDiagnostics.get(0);
                    throw new EglRuntimeException("Invalid patch. Line " + patchValidationDiagnostic.getLine().getNumber() + ": " + patchValidationDiagnostic.getReason(), new IllegalStateException());
                }
                TextBlock newContentsBlock = patch.apply(existingContentsBlock);
                this.newContents = newContentsBlock.getLines().stream().map(Line::getText).collect(Collectors.joining(System.lineSeparator()));
                break;
            }
            default: {
                throw new EglRuntimeException("Unsupported output mode " + (Object)((Object)this.outputMode), new IllegalStateException());
            }
        }
    }

    protected void writeNewContentsIfDifferentFromExistingContents() throws URISyntaxException, IOException {
        if (this.isOverwriteUnchangedFiles() || !this.newContents.equals(this.existingContents)) {
            this.write();
            this.addMessage(String.valueOf(this.getPositiveMessage()) + this.getTargetName());
        } else {
            this.addMessage("Content unchanged for " + this.getTargetName());
        }
    }

    protected boolean isOverwriteUnchangedFiles() {
        return this.getIncrementalitySettings().isOverwriteUnchangedFiles();
    }

    protected void write() throws IOException, URISyntaxException {
        if (this.getTarget() != null) {
            FileUtil.write(this.getTarget(), this.getNewContents());
        }
        this.currentOutputFile = this.getTemplate().addOutputFile(this.getTargetName(), UriUtil.fileToUri((File)this.getTarget()));
        if (this.getOutputMode() == OutputMode.MERGE) {
            for (LocatedRegion pr : this.module.getContext().getPartitioner().partition(this.getNewContents()).getLocatedRegions()) {
                this.getCurrentOutputFile().addProtectedRegion(pr.getId(), pr.isEnabled(), pr.getOffset());
            }
        }
    }

    @Override
    protected void addProtectedRegionWarning(ProtectedRegionWarning warning) {
        super.addProtectedRegionWarning(new ProtectedRegionWarning(warning.getId(), this.target.getAbsolutePath()));
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public OutputFile getCurrentOutputFile() {
        return this.currentOutputFile;
    }

    public void setCurrentOutputFile(OutputFile currentOutputFile) {
        this.currentOutputFile = currentOutputFile;
    }

    public String getExistingContents() {
        return this.existingContents;
    }

    public void setExistingContents(String existingContents) {
        this.existingContents = existingContents;
    }

    public String getNewContents() {
        return this.newContents;
    }

    public void setNewContents(String newContents) {
        this.newContents = newContents;
    }

    public String getPositiveMessage() {
        return this.positiveMessage;
    }

    public void setPositiveMessage(String positiveMessage) {
        this.positiveMessage = positiveMessage;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public void setOutputMode(OutputMode outputMode) {
        this.outputMode = outputMode;
    }

    public static enum OutputMode {
        WRITE,
        MERGE,
        APPEND,
        PATCH;

    }
}

