/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epsilon.common.module.Comment;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.Region;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.IEglModule;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.IImportManager;
import org.eclipse.epsilon.eol.debug.IEolDebugger;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.dom.ModelDeclaration;
import org.eclipse.epsilon.eol.dom.OperationList;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EglModule
implements IEglModule {
    private EglTemplateFactory templateFactory;
    private EglTemplate current;

    public EglModule() {
        this(new EglTemplateFactory());
    }

    public EglModule(EglTemplateFactory factory) {
        this.templateFactory = factory;
    }

    @Override
    public EglTemplateFactory getTemplateFactory() {
        return this.templateFactory;
    }

    @Override
    public void setTemplateFactory(EglTemplateFactory templateFactory) {
        this.templateFactory = templateFactory;
    }

    @Deprecated
    public EglTemplateFactory getFactory() {
        return this.getTemplateFactory();
    }

    @Deprecated
    public void setFactory(EglTemplateFactory factory) {
        this.setTemplateFactory(factory);
    }

    @Override
    public EglTemplate getCurrentTemplate() {
        return this.current;
    }

    public boolean parse(File file) throws Exception {
        this.current = this.templateFactory.load(file);
        return this.getParseProblems().isEmpty();
    }

    public boolean parse(URI uri) throws Exception {
        this.current = this.templateFactory.load(uri);
        return this.getParseProblems().isEmpty();
    }

    public boolean parse(String code) throws Exception {
        this.current = this.templateFactory.prepare(code);
        return this.getParseProblems().isEmpty();
    }

    public boolean parse(String code, File file) throws Exception {
        this.current = this.templateFactory.load(code, file);
        return this.current.getParseProblems().isEmpty();
    }

    @Override
    public boolean parse(String code, URI uri) throws Exception {
        this.current = this.templateFactory.load(code, uri);
        return this.current.getParseProblems().isEmpty();
    }

    public List<ParseProblem> getParseProblems() {
        return this.current == null ? new LinkedList() : this.current.getParseProblems();
    }

    public Object execute() throws EolRuntimeException {
        return this.current == null ? null : this.current.process();
    }

    @Override
    public void reset() {
        this.current = null;
    }

    @Override
    public IEglContext getContext() {
        return this.templateFactory.getContext();
    }

    public List<ModelDeclaration> getDeclaredModelDeclarations() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getDeclaredModelDeclarations();
    }

    public OperationList getDeclaredOperations() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getDeclaredOperations();
    }

    public List<Import> getImports() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getImports();
    }

    public Set<ModelDeclaration> getModelDeclarations() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getModelDeclarations();
    }

    public OperationList getOperations() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getOperations();
    }

    @Override
    public void setDefaultFormatters(Collection<Formatter> defaultFormatters) {
        this.templateFactory.setDefaultFormatters(defaultFormatters);
    }

    public IEolModule getParentModule() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getParentModule();
    }

    public void setParentModule(IEolModule parent) {
        if (this.current != null) {
            this.current.module.setParentModule(parent);
        }
    }

    public URI getSourceUri() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getSourceUri();
    }

    public void setContext(IEolContext context) {
        if (context instanceof IEglContext) {
            this.templateFactory.setContext((IEglContext)context);
            if (this.current != null) {
                this.current.module.setContext(context);
            }
        }
    }

    public ModuleElement createAst(AST cst, ModuleElement parentAst) {
        if (this.current == null) {
            return null;
        }
        return this.current.module.createAst(cst, parentAst);
    }

    public File getFile() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getFile();
    }

    public URI getUri() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getUri();
    }

    public void setUri(URI uri) {
        if (this.current != null) {
            this.current.module.setUri(uri);
        }
    }

    public void setModule(IModule module) {
        if (this.current != null) {
            this.current.module.setModule(module);
        }
    }

    public void build(AST cst, IModule module) {
        if (this.current != null) {
            this.current.module.build(cst, module);
        }
    }

    public Region getRegion() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getRegion();
    }

    public void setRegion(Region region) {
        if (this.current != null) {
            this.current.module.setRegion(region);
        }
    }

    public ModuleElement getParent() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getParent();
    }

    public void setParent(ModuleElement moduleElement) {
        if (this.current != null) {
            this.current.module.setParent(moduleElement);
        }
    }

    public List<ModuleElement> getChildren() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getChildren();
    }

    public IModule getModule() {
        if (this.current == null) {
            return null;
        }
        return this.current.module;
    }

    public StatementBlock getMain() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getMain();
    }

    public List<Statement> getPostOperationStatements() {
        if (this.current == null) {
            return null;
        }
        return this.current.module.getPostOperationStatements();
    }

    public List<Comment> getComments() {
        return this.current.module.getComments();
    }

    public Map<String, Object> getData() {
        return this.current.getModule().getData();
    }

    public IImportManager getImportManager() {
        return this.current.module.getImportManager();
    }

    public void setImportManager(IImportManager importManager) {
        this.current.module.setImportManager(importManager);
    }

    public IEolDebugger createDebugger() {
        return this.current.module.createDebugger();
    }
}

