/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.status.StatusMessage;
import org.eclipse.epsilon.egl.util.FileUtil;

public abstract class EglPersistentTemplate
extends EglTemplate {
    protected final URI outputRoot;
    protected final String outputRootPath;

    public EglPersistentTemplate(EglTemplateSpecification spec, IEglContext context, URI outputRoot) throws Exception {
        this(spec, context, outputRoot, outputRoot != null ? outputRoot.getPath() : null);
    }

    public EglPersistentTemplate(EglTemplateSpecification spec, IEglContext context, URI outputRoot, String outputRootPath) throws Exception {
        super(spec, context);
        this.outputRoot = outputRoot;
        this.outputRootPath = outputRootPath;
    }

    protected File resolveFile(String path) throws EglRuntimeException {
        try {
            String encodedPath = UriUtil.encode((String)path, (boolean)false);
            URI resolved = UriUtil.resolve((String)encodedPath, (URI[])new URI[]{this.outputRoot});
            if ("file".equals(resolved.getScheme())) {
                return new File(resolved);
            }
            return new File(new URI("file:///" + resolved.toString()));
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + path, e, (ModuleElement)this.module);
        }
    }

    public void store(String path) throws EglRuntimeException {
        this.generate(path, false, false);
        this.printStoreDeprecationWarning("store(path, overwrite)", "generate(path, false, false)");
    }

    public void store(String path, boolean overwrite) throws EglRuntimeException {
        this.generate(path, overwrite, false);
        this.printStoreDeprecationWarning("store(path, overwrite)", "generate(path, overwrite, false)");
    }

    private void printStoreDeprecationWarning(String deprecatedCode, String replacementCode) {
        String message = String.valueOf(deprecatedCode) + " is deprecated and will be removed in a future version of EGL. " + "generate(path), which respects protected regions, is preferred. " + "Alternatively, use " + replacementCode + " if you really know what you are doing.";
        this.printWarning(message);
    }

    public final void generate(String path) throws EglRuntimeException {
        this.generate(path, true, true);
    }

    public File generate(String path, boolean overwrite, boolean merge) throws EglRuntimeException {
        File outputFile = this.resolveFile(path);
        if (overwrite || !outputFile.exists()) {
            if (!this.isProcessed()) {
                this.process();
            }
            this.doGenerate(outputFile, this.name(path), overwrite, merge);
            for (ITemplateExecutionListener listener : this.listeners) {
                listener.finishedGenerating(this, this.name(path));
            }
        } else {
            this.addMessage("Existing contents of " + this.name(path) + " were preserved.");
        }
        return outputFile;
    }

    protected String name(String path) {
        if (this.outputRootPath == null) {
            return path;
        }
        return String.valueOf(new File(this.outputRootPath).getPath()) + FileUtil.FILE_SEP + path;
    }

    protected abstract void doGenerate(File var1, String var2, boolean var3, boolean var4) throws EglRuntimeException;

    protected void addMessage(String message) {
        this.module.getContext().addStatusMessage(new StatusMessage(message));
    }
}

