/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.egl.formatter.CompositeFormatter;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.formatter.NullFormatter;
import org.eclipse.epsilon.egl.incremental.IncrementalitySettings;
import org.eclipse.epsilon.egl.internal.EglModule;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.merge.Merger;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecificationFactory;
import org.eclipse.epsilon.egl.status.ProtectedRegionWarning;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.eol.IImportManager;
import org.eclipse.epsilon.eol.ImportManager;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.dom.ModelDeclaration;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.dom.OperationList;

public class EglTemplate {
    protected final IEglModule module;
    protected final String name;
    protected final Template template;
    protected final Collection<ITemplateExecutionListener> listeners;
    private IncrementalitySettings incrementalitySettings;
    private Formatter formatter;
    private String contents = "";
    private boolean processed = false;

    EglTemplate(URI path, IEglContext context) throws Exception {
        this(new EglTemplateSpecificationFactory(new NullFormatter(), new IncrementalitySettings(), (IImportManager)new ImportManager(), new ITemplateExecutionListener[0]).fromResource(path.toString(), path), context);
    }

    public EglTemplate(EglTemplateSpecification spec, IEglContext context) throws Exception {
        this(spec.getName(), context, spec.createTemplate(), spec.getDefaultFormatter(), spec.getIncrementalitySettings(), spec.getTemplateExecutionListeners(), spec.getImportManager());
        spec.parseInto(this.module);
    }

    private EglTemplate(String name, IEglContext context, Template template, Formatter formatter, IncrementalitySettings incrementalitySettings, Collection<ITemplateExecutionListener> listeners, IImportManager importManager) {
        this.module = new EglModule(context);
        this.module.setImportManager(importManager);
        this.name = name;
        this.template = template;
        this.formatter = formatter;
        this.incrementalitySettings = incrementalitySettings;
        this.listeners = listeners;
    }

    public String getName() {
        return this.name;
    }

    public void populate(String name, Object value) {
        this.template.addVariable(name, value);
    }

    public String process() throws EglRuntimeException {
        List parseErrors = this.module.getParseProblems().stream().filter(p -> p.getSeverity() == 0).collect(Collectors.toList());
        if (!parseErrors.isEmpty()) {
            throw new EglRuntimeException("Attempted to process a template with syntax errors: " + ((ParseProblem)parseErrors.iterator().next()).toString(), (ModuleElement)this.module);
        }
        for (ITemplateExecutionListener listener : this.listeners) {
            listener.aboutToProcess(this);
        }
        this.contents = Objects.toString(this.module.execute(this, this.formatter), "");
        this.processed = true;
        for (ITemplateExecutionListener listener : this.listeners) {
            listener.finishedProcessing(this);
        }
        return this.contents;
    }

    public String merge(String existing) throws EglRuntimeException {
        if (!this.isProcessed()) {
            this.process();
        }
        Merger merger = new Merger(this.module.getContext().getPartitioner(), this.contents, existing);
        String result = merger.merge();
        for (ProtectedRegionWarning warning : merger.getMergeWarnings()) {
            this.addProtectedRegionWarning(warning);
        }
        return result;
    }

    protected void addProtectedRegionWarning(ProtectedRegionWarning warning) {
        this.module.getContext().addStatusMessage(warning);
    }

    protected String getContents() {
        return this.contents;
    }

    protected boolean isProcessed() {
        return this.processed;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public IncrementalitySettings getIncrementalitySettings() {
        return this.incrementalitySettings;
    }

    public void setIncrementalitySettings(IncrementalitySettings incrementalitySettings) {
        this.incrementalitySettings = incrementalitySettings;
    }

    public void setFormatters(Formatter ... formatters) {
        this.setFormatters(Arrays.asList(formatters));
    }

    public void setFormatters(Collection<Formatter> formatters) {
        this.setFormatter(new CompositeFormatter(formatters));
    }

    public Template getTemplate() {
        return this.template;
    }

    public IEglModule getModule() {
        return this.module;
    }

    public List<ParseProblem> getParseProblems() {
        return this.module.getParseProblems();
    }

    public List<ModelDeclaration> getDeclaredModelDefinitions() {
        return this.module.getDeclaredModelDeclarations();
    }

    public OperationList getDeclaredOperations() {
        return this.module.getDeclaredOperations();
    }

    public List<Import> getImports() {
        return this.module.getImports();
    }

    public Set<ModelDeclaration> getModelDefinitions() {
        return this.module.getModelDeclarations();
    }

    public OperationList getOperations() {
        return this.module.getOperations();
    }

    protected void printWarning(String message) {
        this.module.getContext().getWarningStream().println(message);
    }

    public void reset() {
        this.processed = false;
        this.template.reset();
        this.contents = "";
        for (Operation op : ((EglModule)this.module).getOperations()) {
            op.clearCache();
        }
    }
}

