/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.EglContext;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.egl.formatter.CompositeFormatter;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.formatter.NullFormatter;
import org.eclipse.epsilon.egl.incremental.IncrementalitySettings;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecificationFactory;
import org.eclipse.epsilon.egl.util.FileUtil;
import org.eclipse.epsilon.eol.IImportManager;
import org.eclipse.epsilon.eol.ImportManager;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;

public class EglTemplateFactory {
    protected IEglContext context;
    protected URI root;
    private URI templateRoot;
    private String templateRootPath;
    private Formatter defaultFormatter = new NullFormatter();
    private IncrementalitySettings defaultIncrementalitySettings = new IncrementalitySettings();
    private final Collection<ITemplateExecutionListener> listeners = new LinkedList<ITemplateExecutionListener>();
    private IImportManager importManager = new ImportManager();

    public EglTemplateFactory() {
        this(null);
    }

    public EglTemplateFactory(IEglContext context) {
        this.context = context != null ? context : new EglContext(this);
    }

    public Collection<ITemplateExecutionListener> getTemplateExecutionListeners() {
        return this.listeners;
    }

    public IncrementalitySettings getDefaultIncrementalitySettings() {
        return this.defaultIncrementalitySettings;
    }

    public void setDefaultFormatter(Formatter defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    public void setDefaultFormatters(Formatter ... defaultFormatters) {
        this.setDefaultFormatters(Arrays.asList(defaultFormatters));
    }

    public void setDefaultFormatters(Collection<Formatter> defaultFormatters) {
        this.setDefaultFormatter(new CompositeFormatter(defaultFormatters));
    }

    public IEglContext getContext() {
        return this.context;
    }

    public void setContext(IEglContext context) {
        this.context = context;
    }

    public IImportManager getImportManager() {
        return this.importManager;
    }

    public void setImportManager(IImportManager importManager) {
        this.importManager = importManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialiseRoot(URI root) {
        if (this.root == null) {
            EglTemplateFactory eglTemplateFactory = this;
            synchronized (eglTemplateFactory) {
                block5: {
                    if (this.root != null) break block5;
                    this.setRoot(root);
                    return true;
                }
            }
        }
        return false;
    }

    public void setRoot(URI root) {
        this.root = root;
    }

    public String getTemplateRoot() {
        return this.templateRootPath;
    }

    public void setTemplateRoot(String path) throws EglRuntimeException {
        this.templateRootPath = path;
        this.templateRoot = this.resolveRoot(this.templateRootPath);
    }

    protected URI resolveRoot(String path) throws EglRuntimeException {
        try {
            return UriUtil.resolve((String)UriUtil.encode((String)path, (boolean)true), (URI[])new URI[]{this.root});
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + path, e, (ModuleElement)this.getContext().getModule());
        }
    }

    public URI resolveTemplate(String path) throws EglRuntimeException {
        try {
            return UriUtil.resolve((String)UriUtil.encode((String)path, (boolean)false), (URI[])new URI[]{this.templateRoot, this.root});
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + path, e, (ModuleElement)this.getContext().getModule());
        }
    }

    protected String name(String path) {
        String name = path;
        if (this.templateRootPath != null) {
            name = String.valueOf(new File(this.templateRootPath).getPath()) + FileUtil.FILE_SEP + name;
        }
        return name;
    }

    public EglTemplate load(File file) throws EglRuntimeException {
        String name = this.name(file.getAbsolutePath());
        try {
            return this.load(this.createTemplateSpecificationFactory().fromResource(name, UriUtil.fileToUri((File)file)));
        }
        catch (URISyntaxException e) {
            return this.handleFailedLoad(name, e);
        }
    }

    protected EglTemplate load(String code, File file) throws EglRuntimeException {
        String name = this.name(file.getAbsolutePath());
        try {
            return this.load(this.createTemplateSpecificationFactory().fromDirtyResource(name, code, UriUtil.fileToUri((File)file)));
        }
        catch (URISyntaxException e) {
            return this.handleFailedLoad(name, e);
        }
    }

    public EglTemplate load(String path) throws EglRuntimeException {
        return this.load(this.createTemplateSpecificationFactory().fromResource(this.name(path), this.resolveTemplate(path)));
    }

    public EglTemplate load(URI resource) throws EglRuntimeException {
        String name = resource.toString();
        return this.load(this.createTemplateSpecificationFactory().fromResource(name, resource));
    }

    protected EglTemplate load(String code, URI resource) throws EglRuntimeException {
        String name = resource.toString();
        return this.load(this.createTemplateSpecificationFactory().fromDirtyResource(name, code, resource));
    }

    protected final EglTemplate load(EglTemplateSpecification spec) throws EglRuntimeException {
        try {
            this.initialiseRoot(spec.getURI());
            return this.createTemplate(spec);
        }
        catch (Exception e) {
            return this.handleFailedLoad(spec.getName(), e);
        }
    }

    protected EglTemplate handleFailedLoad(String name, Exception e) throws EglRuntimeException {
        String reason = e instanceof FileNotFoundException ? "Template not found" : "Could not process";
        throw new EglRuntimeException(String.valueOf(reason) + " '" + name + "'", e, (ModuleElement)this.getContext().getModule());
    }

    public final EglTemplate prepare(String code) throws Exception {
        return this.createTemplate(this.createTemplateSpecificationFactory().fromCode(code));
    }

    protected EglTemplate createTemplate(EglTemplateSpecification spec) throws Exception {
        return new EglTemplate(spec, this.getContextForNewTemplate());
    }

    public void copyState(IEolContext delegate) {
        this.context.setDelegate(delegate);
    }

    protected IEglContext getContextForNewTemplate() {
        if (this.context.getDelegate() instanceof IEolContextParallel) {
            return new EglContext(this.context);
        }
        this.getContext().setDelegate(this.getContext().getDelegate());
        return this.getContext();
    }

    private EglTemplateSpecificationFactory createTemplateSpecificationFactory() {
        return new EglTemplateSpecificationFactory(this.defaultFormatter, this.defaultIncrementalitySettings, this.importManager, this.listeners.toArray(new ITemplateExecutionListener[this.listeners.size()]));
    }

    public String toString() {
        String root = this.templateRoot == null ? "" : this.templateRoot.toString();
        return String.valueOf(this.getClass().getSimpleName()) + ": root='" + root + "'";
    }
}

