/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.egl.EglFileGeneratingTemplateFactory;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.IEgxModule;
import org.eclipse.epsilon.egl.debug.EgxDebugger;
import org.eclipse.epsilon.egl.dom.GenerationRule;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.EgxContext;
import org.eclipse.epsilon.egl.execute.context.IEgxContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.parse.EgxLexer;
import org.eclipse.epsilon.egl.parse.EgxParser;
import org.eclipse.epsilon.eol.debug.EolDebugger;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.dom.NamedRule;
import org.eclipse.epsilon.erl.dom.NamedRuleList;
import org.eclipse.epsilon.erl.execute.RuleExecutorFactory;
import org.eclipse.epsilon.erl.execute.context.IErlContext;

public class EgxModule
extends ErlModule
implements IEgxModule {
    protected NamedRuleList<GenerationRule> generationRules;
    protected NamedRuleList<GenerationRule> declaredGenerationRules = new NamedRuleList();

    public EgxModule() {
        this((IEgxContext)null);
    }

    public EgxModule(String outputRoot) throws EglRuntimeException {
        this(Paths.get(outputRoot, new String[0]));
    }

    public EgxModule(Path outputRoot) throws EglRuntimeException {
        this();
        this.setFileGeneratingTemplateFactory(outputRoot);
    }

    public EgxModule(IEgxContext context) {
        super((IErlContext)(context != null ? context : new EgxContext()));
    }

    public EgxModule(EglTemplateFactory templateFactory) {
        this(new EgxContext(templateFactory));
    }

    protected void setFileGeneratingTemplateFactory(Path outputRoot) throws EglRuntimeException {
        this.getContext().setTemplateFactory(new EglFileGeneratingTemplateFactory(outputRoot.toAbsolutePath()));
    }

    protected Lexer createLexer(ANTLRInputStream inputStream) {
        return new EgxLexer((CharStream)inputStream);
    }

    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EgxParser(tokenStream);
    }

    public String getMainRule() {
        return "egxModule";
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        List generationRuleChildren = AstUtil.getChildren((AST)cst, (int[])new int[]{87});
        this.declaredGenerationRules.ensureCapacity(generationRuleChildren.size());
        for (AST generationRuleAst : generationRuleChildren) {
            this.declaredGenerationRules.add((NamedRule)((GenerationRule)module.createAst(generationRuleAst, (ModuleElement)this)));
        }
        this.getParseProblems().addAll(this.calculateSuperRules(this.getGenerationRules()));
    }

    public ModuleElement adapt(AST cst, ModuleElement parentAst) {
        switch (cst.getType()) {
            case 87: {
                return this.createGenerationRule(cst);
            }
            case 51: {
                return new ExecutableBlock(Map.class);
            }
            case 90: {
                return new ExecutableBlock(Collection.class);
            }
            case 88: 
            case 89: {
                return new ExecutableBlock(String.class);
            }
            case 86: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                return new ExecutableBlock(Boolean.class);
            }
            case 95: {
                return new ExecutableBlock(Formatter.class);
            }
            case 83: 
            case 84: {
                if (!(parentAst instanceof GenerationRule)) break;
                return new ExecutableBlock(Void.class);
            }
        }
        return super.adapt(cst, parentAst);
    }

    protected GenerationRule createGenerationRule(AST generationRuleAst) {
        return new GenerationRule();
    }

    @Override
    public List<GenerationRule> getDeclaredGenerationRules() {
        return this.declaredGenerationRules;
    }

    public boolean parse(File file) throws Exception {
        boolean result = super.parse(file);
        if (result) {
            this.getContext().getTemplateFactory().initialiseRoot(file.getAbsoluteFile().getParentFile().toURI());
        }
        return result;
    }

    public boolean parse(URI uri) throws Exception {
        boolean result = super.parse(uri);
        if (result) {
            this.getContext().getTemplateFactory().initialiseRoot(uri);
        }
        return result;
    }

    public boolean parse(String code, File file) throws Exception {
        boolean result = super.parse(code, file);
        if (result && file != null) {
            this.getContext().getTemplateFactory().initialiseRoot(file.getAbsoluteFile().getParentFile().toURI());
        }
        return result;
    }

    protected Object processRules() throws EolRuntimeException {
        IEgxContext context = this.getContext();
        RuleExecutorFactory executorFactory = context.getExecutorFactory();
        for (GenerationRule rule : this.getGenerationRules()) {
            executorFactory.execute((ModuleElement)rule, (IEolContext)context);
        }
        return null;
    }

    public HashMap<String, Class<? extends IModule>> getImportConfiguration() {
        HashMap importConfiguration = super.getImportConfiguration();
        importConfiguration.put("egx", EgxModule.class);
        return importConfiguration;
    }

    @Override
    public List<GenerationRule> getGenerationRules() {
        if (this.generationRules == null) {
            this.generationRules = new NamedRuleList();
            for (Import import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEgxModule)) continue;
                IEgxModule module = (IEgxModule)import_.getModule();
                this.generationRules.addAll(module.getGenerationRules());
            }
            this.generationRules.addAll(this.declaredGenerationRules);
        }
        return this.generationRules;
    }

    @Override
    public IEgxContext getContext() {
        return (IEgxContext)super.getContext();
    }

    public EolDebugger createDebugger() {
        return new EgxDebugger();
    }
}

