/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.concurrent;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.egl.EgxModule;
import org.eclipse.epsilon.egl.concurrent.EgxModuleParallelAnnotation;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.concurrent.EgxContextParallel;
import org.eclipse.epsilon.egl.execute.context.concurrent.IEgxContextParallel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.IEolContextParallel;

public abstract class EgxModuleParallel
extends EgxModule {
    protected static final Set<String> CONFIG_PROPERTIES = new HashSet<String>(2);

    static {
        CONFIG_PROPERTIES.add("parallelism");
    }

    public EgxModuleParallel() {
        this((IEgxContextParallel)null);
    }

    public EgxModuleParallel(Path outputRoot) throws EglRuntimeException {
        this();
        if (outputRoot != null) {
            this.setFileGeneratingTemplateFactory(outputRoot);
        }
    }

    public EgxModuleParallel(IEgxContextParallel context) {
        super(context != null ? context : new EgxContextParallel());
    }

    @Override
    protected abstract Object processRules() throws EolRuntimeException;

    @Override
    public IEgxContextParallel getContext() {
        return (IEgxContextParallel)super.getContext();
    }

    @Override
    public HashMap<String, Class<? extends IModule>> getImportConfiguration() {
        HashMap<String, Class<? extends IModule>> importConfiguration = super.getImportConfiguration();
        importConfiguration.put("egx", EgxModuleParallelAnnotation.class);
        return importConfiguration;
    }

    public void configure(Map<String, ?> properties) throws IllegalArgumentException {
        super.configure(properties);
        IEgxContextParallel context = this.getContext();
        this.setContext((IEolContext)IEolContextParallel.configureContext(properties, threads -> new EgxContextParallel(context.getTemplateFactory(), (int)threads), (IEolContextParallel)context));
    }

    public Set<String> getConfigurationProperties() {
        return CONFIG_PROPERTIES;
    }
}

