/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.concurrent;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.egl.concurrent.EgxModuleParallel;
import org.eclipse.epsilon.egl.dom.GenerationRule;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEgxContext;
import org.eclipse.epsilon.egl.execute.context.concurrent.EgxContextParallel;
import org.eclipse.epsilon.eol.dom.AnnotatableModuleElement;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.concurrent.IErlModuleParallelAnnotation;
import org.eclipse.epsilon.erl.execute.RuleExecutorFactory;

public class EgxModuleParallelAnnotation
extends EgxModuleParallel
implements IErlModuleParallelAnnotation {
    public EgxModuleParallelAnnotation() {
    }

    public EgxModuleParallelAnnotation(Path outputRoot) throws EglRuntimeException {
        super(outputRoot);
    }

    public EgxModuleParallelAnnotation(EgxContextParallel context) {
        super(context);
    }

    @Override
    protected Object processRules() throws EolRuntimeException {
        EgxContextParallel pContext = (EgxContextParallel)this.getContext();
        RuleExecutorFactory executorFactory = pContext.getExecutorFactory();
        for (GenerationRule rule : this.getGenerationRules()) {
            Collection<?> allElements = rule.getAllElements((IEolContext)pContext);
            ArrayList<Callable<Object>> genJobs = new ArrayList<Callable<Object>>(allElements.size());
            for (Object element : allElements) {
                if (this.shouldBeParallel((AnnotatableModuleElement)rule, element)) {
                    genJobs.add(() -> {
                        IEgxContext sContext = pContext.getShadow();
                        return sContext.getExecutorFactory().execute((IExecutableModuleElementParameter)rule, (IEolContext)sContext, element);
                    });
                    continue;
                }
                executorFactory.execute((IExecutableModuleElementParameter)rule, (IEolContext)pContext, element);
            }
            pContext.executeAll((ModuleElement)rule, genJobs);
        }
        return null;
    }
}

