/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.debug;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.IEgxModule;
import org.eclipse.epsilon.egl.dom.GenerationRule;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.execute.control.DefaultTemplateExecutionListener;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.eol.debug.BreakpointRequest;
import org.eclipse.epsilon.eol.debug.BreakpointResult;
import org.eclipse.epsilon.eol.debug.BreakpointState;
import org.eclipse.epsilon.eol.debug.EolDebugger;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;

public class EgxDebugger
extends EolDebugger {
    protected boolean isStructuralBlock(ModuleElement ast) {
        return super.isStructuralBlock(ast) || ast instanceof GenerationRule;
    }

    public void control(ModuleElement ast, IEolContext context) {
        IEgxModule egxModule;
        Collection<ITemplateExecutionListener> templateListeners;
        boolean hasListener;
        if (ast instanceof IEgxModule && !(hasListener = (templateListeners = (egxModule = (IEgxModule)ast).getTemplateFactory().getTemplateExecutionListeners()).stream().anyMatch(l -> l instanceof DebugTemplateListener))) {
            templateListeners.add(new DebugTemplateListener(() -> egxModule.getContext().getExecutorFactory().getExecutionListeners()));
        }
        super.control(ast, context);
    }

    public BreakpointResult verifyBreakpoint(BreakpointRequest request) {
        BreakpointResult result = super.verifyBreakpoint(request);
        if (result.getState() == BreakpointState.VERIFIED) {
            return result;
        }
        return BreakpointResult.pending((BreakpointRequest)request);
    }

    protected class DebugTemplateListener
    extends DefaultTemplateExecutionListener {
        private final Supplier<Collection<IExecutionListener>> listenerSupplier;

        public DebugTemplateListener(Supplier<Collection<IExecutionListener>> listenerSupplier) {
            this.listenerSupplier = listenerSupplier;
        }

        @Override
        public void aboutToProcess(EglTemplate template) {
            IEglContext context = template.getModule().getContext();
            ExecutorFactory executorFactory = context.getExecutorFactory();
            Collection existingListeners = executorFactory.getExecutionListeners();
            for (IExecutionListener l : this.listenerSupplier.get()) {
                if (existingListeners.contains(l)) continue;
                executorFactory.addExecutionListener(l);
            }
        }
    }
}

