/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.dom;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.egl.EglFileGeneratingTemplate;
import org.eclipse.epsilon.egl.EglPersistentTemplate;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.dom.IEgxVisitor;
import org.eclipse.epsilon.egl.execute.context.IEgxContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElement;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.erl.dom.ExtensibleNamedRule;

public class GenerationRule
extends ExtensibleNamedRule
implements IExecutableModuleElementParameter,
IExecutableModuleElement {
    protected Parameter sourceParameter;
    protected ExecutableBlock<Collection<?>> domainBlock;
    protected ExecutableBlock<String> targetBlock;
    protected ExecutableBlock<String> templateBlock;
    protected ExecutableBlock<Boolean> guardBlock;
    protected ExecutableBlock<Boolean> overwriteBlock;
    protected ExecutableBlock<Boolean> mergeBlock;
    protected ExecutableBlock<Boolean> appendBlock;
    protected ExecutableBlock<Boolean> patchBlock;
    protected ExecutableBlock<?> preBlock;
    protected ExecutableBlock<?> postBlock;
    protected ExecutableBlock<EolMap<String, ?>> parametersBlock;
    protected ExecutableBlock<Formatter> formatterBlock;

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        GenerationRule.validateConstructs(cst, module.getParseProblems());
        AST sourceParameterAst = cst.getFirstChild().getNextSibling();
        if (sourceParameterAst != null && sourceParameterAst.getType() == 28) {
            this.sourceParameter = (Parameter)module.createAst(sourceParameterAst, (ModuleElement)this);
        }
        this.domainBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)90), (ModuleElement)this);
        this.guardBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)86), (ModuleElement)this);
        this.preBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)83), (ModuleElement)this);
        this.overwriteBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)91), (ModuleElement)this);
        this.mergeBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)92), (ModuleElement)this);
        this.appendBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)94), (ModuleElement)this);
        this.patchBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)93), (ModuleElement)this);
        this.templateBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)89), (ModuleElement)this);
        this.parametersBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)51), (ModuleElement)this);
        this.targetBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)88), (ModuleElement)this);
        this.postBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)84), (ModuleElement)this);
        this.formatterBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)95), (ModuleElement)this);
    }

    private static void validateConstructs(AST parent, Collection<ParseProblem> problems) {
        int[] types = new int[]{90, 86, 83, 91, 92, 94, 93, 89, 51, 88, 84};
        String[] names = new String[]{"domain", "guard", "pre", "overwrite", "merge", "append", "patch", "template", "parameters", "target", "post"};
        int i = 0;
        while (i < types.length) {
            if (!AstUtil.hasAtMostNChildrenOfTypes((int)1, (AST)parent, (int[])new int[]{types[i]})) {
                problems.add(new ParseProblem(parent.getLine(), parent.getColumn(), "At most one '" + names[i] + "' block is permitted in each rule", 0));
            }
            ++i;
        }
    }

    public Collection<?> getAllElements(IEolContext context) throws EolRuntimeException {
        if (this.sourceParameter != null) {
            if (this.domainBlock == null) {
                return this.getAllInstances(this.sourceParameter, context, !this.isGreedy(context));
            }
            return (Collection)this.domainBlock.execute(context, true, new Variable[0]);
        }
        return Collections.singleton(null);
    }

    public Object execute(IEolContext context_, Object element) throws EolRuntimeException {
        String target;
        EglTemplate eglTemplate;
        IEgxContext context = (IEgxContext)context_;
        FrameStack frameStack = context.getFrameStack();
        if (this.sourceParameter != null) {
            frameStack.enterLocal(FrameType.PROTECTED, (ModuleElement)this, new Variable[]{Variable.createReadOnlyVariable((String)this.sourceParameter.getName(), (Object)element)});
        } else {
            frameStack.enterLocal(FrameType.PROTECTED, (ModuleElement)this, new Variable[0]);
        }
        if (this.guardBlock != null && !((Boolean)this.guardBlock.execute((IEolContext)context, false, new Variable[0])).booleanValue()) {
            frameStack.leaveLocal((ModuleElement)this);
            return null;
        }
        if (this.preBlock != null) {
            this.preBlock.execute((IEolContext)context, false, new Variable[0]);
        }
        boolean overwrite = this.overwriteBlock == null ? true : (Boolean)this.overwriteBlock.execute((IEolContext)context, false, new Variable[0]);
        boolean merge = this.mergeBlock == null ? true : (Boolean)this.mergeBlock.execute((IEolContext)context, false, new Variable[0]);
        boolean append = this.appendBlock == null ? false : (Boolean)this.appendBlock.execute((IEolContext)context, false, new Variable[0]);
        boolean patch = this.patchBlock == null ? false : (Boolean)this.patchBlock.execute((IEolContext)context, false, new Variable[0]);
        String templateName = this.templateBlock == null ? "" : (String)this.templateBlock.execute((IEolContext)context, false, new Variable[0]);
        EglTemplateFactory templateFactory = context.getTemplateFactory();
        Map<URI, EglTemplate> templateCache = context.getTemplateCache();
        URI templateUri = templateFactory.resolveTemplate(templateName);
        if (templateCache == null || (eglTemplate = templateCache.get(templateUri)) == null) {
            eglTemplate = templateFactory.load(templateUri);
            List<ParseProblem> problems = eglTemplate.getParseProblems();
            if (!problems.isEmpty()) {
                ParseProblem problem = problems.get(0);
                String reason = "Parse error(s) in " + templateUri + ": " + problem.toString();
                throw new EolRuntimeException(reason, this.templateBlock);
            }
            if (templateCache != null) {
                templateCache.put(templateUri, eglTemplate);
            }
        }
        if (this.sourceParameter != null) {
            eglTemplate.populate(this.sourceParameter.getName(), element);
        }
        if (this.parametersBlock != null) {
            for (Map.Entry entry : ((EolMap)this.parametersBlock.execute((IEolContext)context, false, new Variable[0])).entrySet()) {
                eglTemplate.populate((String)entry.getKey(), entry.getValue());
            }
        }
        String string = target = this.targetBlock != null ? (String)this.targetBlock.execute((IEolContext)context, false, new Variable[0]) : null;
        if (this.formatterBlock != null) {
            Formatter formatter = (Formatter)this.formatterBlock.execute((IEolContext)context, false, new Variable[0]);
            eglTemplate.setFormatter(formatter);
        }
        Object generated = eglTemplate instanceof EglPersistentTemplate && target != null ? ((this.getBooleanAnnotationValue("patch", (IEolContext)context) || patch) && eglTemplate instanceof EglFileGeneratingTemplate ? ((EglFileGeneratingTemplate)eglTemplate).patch(target) : ((this.getBooleanAnnotationValue("append", (IEolContext)context) || append) && eglTemplate instanceof EglFileGeneratingTemplate ? ((EglFileGeneratingTemplate)eglTemplate).append(target) : ((EglPersistentTemplate)eglTemplate).generate(target, overwrite, merge))) : eglTemplate.process();
        context.getInvokedTemplates().add(eglTemplate.getTemplate());
        if (this.postBlock != null) {
            frameStack.enterLocal(FrameType.UNPROTECTED, this.postBlock, new Variable[]{Variable.createReadOnlyVariable((String)"generated", (Object)generated)});
            this.postBlock.execute((IEolContext)context, false, new Variable[0]);
            frameStack.leaveLocal(this.postBlock);
        }
        frameStack.leaveLocal((ModuleElement)this);
        eglTemplate.reset();
        return generated;
    }

    public Object execute(IEolContext context) throws EolRuntimeException {
        ExecutorFactory executorFactory = context.getExecutorFactory();
        for (Object element : this.getAllElements(context)) {
            executorFactory.execute((IExecutableModuleElementParameter)this, context, element);
        }
        return null;
    }

    public IModel getOwningModelForType(IEolContext context) throws EolRuntimeException {
        if (this.sourceParameter == null) {
            return null;
        }
        EolType parameterType = this.sourceParameter.getType(context);
        if (parameterType instanceof EolModelElementType) {
            return ((EolModelElementType)parameterType).getModel();
        }
        return null;
    }

    public String toString() {
        String label = this.getName();
        if (this.sourceParameter != null) {
            label = String.valueOf(label) + " (" + this.sourceParameter.getTypeName() + ")";
        }
        return label;
    }

    public AST getSuperRulesAst(AST cst) {
        return null;
    }

    public void accept(IEgxVisitor visitor) {
        visitor.visit(this);
    }

    public Parameter getTransformSource() {
        return this.sourceParameter;
    }

    public boolean hasTransformSource() {
        return this.sourceParameter != null;
    }

    public ExecutableBlock<? extends Collection<?>> getDomainBlock() {
        return this.domainBlock;
    }

    public ExecutableBlock<String> getTargetBlock() {
        return this.targetBlock;
    }

    public ExecutableBlock<String> getTemplateBlock() {
        return this.templateBlock;
    }

    public ExecutableBlock<Boolean> getGuardBlock() {
        return this.guardBlock;
    }

    public ExecutableBlock<Boolean> getOverwriteBlock() {
        return this.overwriteBlock;
    }

    public ExecutableBlock<Boolean> getMergeBlock() {
        return this.mergeBlock;
    }

    public ExecutableBlock<?> getPreBlock() {
        return this.preBlock;
    }

    public ExecutableBlock<?> getPostBlock() {
        return this.postBlock;
    }

    public ExecutableBlock<EolMap<String, ?>> getParametersBlock() {
        return this.parametersBlock;
    }

    public ExecutableBlock<Formatter> getFormatterBlock() {
        return this.formatterBlock;
    }
}

