/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.dom;

import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.output.OutputBuffer;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class TemplateOperation
extends Operation {
    protected Return executeBody(IEolContext context) throws EolRuntimeException {
        IEglContext eglContext = (IEglContext)context;
        OutputBuffer out = new OutputBuffer(eglContext){

            @Override
            public int getOffset() {
                String noWhitespace = "no-whitespace";
                if (this.parent != null && this.parent instanceof OutputBuffer) {
                    OutputBuffer parentBuffer = (OutputBuffer)this.parent;
                    String indentation = parentBuffer.calculateIndentationToMatch(parentBuffer.getLastLineInBuffer());
                    String[] lines = StringUtil.toString((Object)(String.valueOf(this.toString()) + noWhitespace)).split(this.getNewline());
                    int offset = super.getOffset() + Math.max(0, lines.length - 1) * indentation.length();
                    return offset;
                }
                return super.getOffset();
            }
        };
        out.setIndenters(eglContext.getOutputBuffer().getIndenters());
        String outName = "out";
        FrameStack frameStack = context.getFrameStack();
        Variable outVariable = frameStack.get("out");
        if (outVariable != null && outVariable.getValue() instanceof IOutputBuffer) {
            out.setParent((IOutputBuffer)outVariable.getValue());
        }
        frameStack.enterGlobal(FrameType.UNPROTECTED, (ModuleElement)this, new Variable[]{Variable.createReadOnlyVariable((String)"out", (Object)out)});
        try {
            super.executeBody(context);
        }
        finally {
            frameStack.leaveGlobal((ModuleElement)this);
        }
        return new Return((Object)out.getOutdentationFormatter().format(out.toString()));
    }
}

