/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.exceptions;

import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class EglRuntimeException
extends EolRuntimeException {
    private static final long serialVersionUID = 2370066735399525557L;
    private final Throwable cause;
    private final int line;
    private final int column;

    public EglRuntimeException(EolRuntimeException ex) {
        super(ex.getReason(), ex.getAst());
        this.reason = ex.getReason();
        this.cause = null;
        this.line = ex.getAst().getRegion().getStart().getLine();
        this.column = ex.getColumn();
        this.ast = ex.getAst();
    }

    public EglRuntimeException(EolInternalException ex) {
        super(ex.getReason(), ex.getAst());
        EglRuntimeException internal = (EglRuntimeException)((Object)ex.getInternal());
        this.reason = internal.getReason();
        this.cause = internal.getCause();
        this.line = ex.getLine();
        this.column = ex.getColumn();
        this.ast = ex.getAst();
    }

    public EglRuntimeException(String reason, ModuleElement ast) {
        this(reason, null, ast);
    }

    public EglRuntimeException(Throwable cause) {
        this(cause.getMessage(), cause, 1, 1, null);
    }

    public EglRuntimeException(String reason, Throwable cause) {
        this(reason, cause, 1, 1, null);
    }

    public EglRuntimeException(String reason, Throwable cause, ModuleElement ast) {
        this(reason, cause, ast != null ? ast.getRegion().getStart().getLine() : 0, ast != null ? ast.getRegion().getStart().getColumn() : 0, ast);
    }

    private EglRuntimeException(String reason, Throwable cause, int line, int column, ModuleElement ast) {
        this.reason = reason;
        this.cause = cause;
        this.line = line;
        this.column = column;
        this.ast = ast;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        String result = super.toString();
        if (this.cause != null) {
            result = String.valueOf(result) + "\n\tCause: " + this.cause.toString();
        }
        return result;
    }
}

