/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.config.ContentTypeRepository;
import org.eclipse.epsilon.egl.config.XMLContentTypeRepository;
import org.eclipse.epsilon.egl.execute.context.EglExecutionManager;
import org.eclipse.epsilon.egl.execute.context.ExecutableTemplateSpecification;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.execute.operations.EglOperationFactory;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.merge.partition.CommentBlockPartitioner;
import org.eclipse.epsilon.egl.merge.partition.CompositePartitioner;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.status.StatusMessage;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.eol.execute.context.EolContext;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;
import org.eclipse.epsilon.eol.types.EolClasspathNativeTypeDelegate;

public class EglContext
extends EolContext
implements IEglContext {
    private EglTemplateFactory templateFactory;
    private List<StatusMessage> statusMessages = new LinkedList<StatusMessage>();
    private CompositePartitioner partitioner = new CompositePartitioner(new CommentBlockPartitioner[0]);
    private ContentTypeRepository repository = new XMLContentTypeRepository(this);
    private EglExecutionManager executionManager = new EglExecutionManager(this);
    private IEolContext delegate;

    public EglContext() {
        this((EglTemplateFactory)null);
    }

    public EglContext(EglTemplateFactory templateFactory) {
        this.classpathNativeTypeDelegate = new EolClasspathNativeTypeDelegate(this.getClass().getClassLoader());
        this.templateFactory = templateFactory != null ? templateFactory : new EglTemplateFactory(this);
        this.setOperationFactory(new EglOperationFactory());
        this.populateFrameStack();
    }

    public EglContext(IEglContext other) {
        this(other.getTemplateFactory());
        this.setDelegate(other.getDelegate());
        if (other instanceof EglContext) {
            EglContext eglContext = (EglContext)other;
            this.statusMessages = eglContext.statusMessages;
        } else {
            this.statusMessages.addAll(other.getStatusMessages());
        }
    }

    private void populateFrameStack() {
        this.getFrameStack().put(new Variable[]{Variable.createReadOnlyVariable((String)"TemplateFactory", (Object)this.templateFactory), Variable.createReadOnlyVariable((String)"openTag", (Object)"[%"), Variable.createReadOnlyVariable((String)"openOutputTag", (Object)"[%="), Variable.createReadOnlyVariable((String)"closeTag", (Object)"%]")});
    }

    public void setOperationContributorRegistry(OperationContributorRegistry ocr) {
        this.methodContributorRegistry = ocr;
    }

    @Override
    public void setDelegate(IEolContext delegate) {
        this.delegate = delegate;
        if (this.delegate == null) {
            return;
        }
        IEglContext.super.setDelegate(delegate);
        this.setOperationContributorRegistry(delegate.getOperationContributorRegistry());
    }

    @Override
    public IEolContext getDelegate() {
        return this.delegate;
    }

    @Override
    public EglTemplateFactory getTemplateFactory() {
        return this.templateFactory;
    }

    @Override
    public CompositePartitioner getPartitioner() {
        return this.partitioner;
    }

    @Override
    public void setPartitioner(CompositePartitioner partitioner) {
        this.partitioner = partitioner;
    }

    @Override
    public ContentTypeRepository getContentTypeRepository() {
        return this.repository;
    }

    @Override
    public void setContentTypeRepository(ContentTypeRepository repository) {
        this.repository = repository;
    }

    @Override
    public void addStatusMessage(StatusMessage message) {
        this.statusMessages.add(message);
    }

    @Override
    public List<StatusMessage> getStatusMessages() {
        return Collections.unmodifiableList(this.statusMessages);
    }

    @Override
    public void enter(EglTemplate template) {
        this.executionManager.prepareFor(template);
    }

    @Override
    public void exit() {
        this.executionManager.restore();
    }

    @Override
    public IOutputBuffer getOutputBuffer() {
        return this.executionManager.getCurrent().outputBuffer;
    }

    @Override
    public Template getTrace() {
        ExecutableTemplateSpecification base = this.executionManager.getBase();
        if (base != null && base.template != null) {
            return base.template.getTemplate();
        }
        return null;
    }

    @Override
    public EglTemplate getCurrentTemplate() {
        return this.executionManager.getCurrent().template;
    }

    @Override
    public IEglModule getModule() {
        IEglModule tm;
        EglTemplate template;
        ExecutableTemplateSpecification ts = this.executionManager.getCurrent();
        if (ts != null && (template = this.getCurrentTemplate()) != null && (tm = template.getModule()) != null) {
            return tm;
        }
        return (IEglModule)super.getModule();
    }

    public EglOperationFactory getOperationFactory() {
        return (EglOperationFactory)super.getOperationFactory();
    }
}

