/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.execute.context.ExecutableTemplateSpecification;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;

class EglExecutionManager {
    final IEglContext context;
    FrameStack frameStack;
    final Deque<ModuleElement> localMarkers = new ArrayDeque<ModuleElement>();
    final Deque<ModuleElement> globalMarkers = new ArrayDeque<ModuleElement>();
    final Deque<ExecutableTemplateSpecification> specs = new LinkedList<ExecutableTemplateSpecification>();
    private ExecutableTemplateSpecification firstSpec;

    public EglExecutionManager(IEglContext context) {
        this.context = context;
    }

    public void prepareFor(EglTemplate template) {
        this.prepareFor(template, this.context.newOutputBuffer());
    }

    public void prepareFor(EglTemplate template, IOutputBuffer outputBuffer) {
        ExecutableTemplateSpecification spec = new ExecutableTemplateSpecification(template, outputBuffer);
        if (this.firstSpec == null) {
            this.firstSpec = spec;
        }
        if (!this.specs.isEmpty()) {
            this.getCurrent().addAsChild(spec);
        }
        this.specs.push(spec);
        this.setModule();
        this.prepareFrameStack();
        spec.addVariablesTo(this.frameStack);
    }

    private void prepareFrameStack() {
        this.frameStack = this.context.getFrameStack();
        StatementBlock frameGlobalStackMarker = new StatementBlock(new Statement[0]);
        frameGlobalStackMarker.setUri(URI.create("template-specific-globals"));
        this.globalMarkers.push((ModuleElement)frameGlobalStackMarker);
        this.frameStack.enterGlobal(FrameType.UNPROTECTED, (ModuleElement)frameGlobalStackMarker, new Variable[0]);
        StatementBlock frameLocalStackMarker = new StatementBlock(new Statement[0]);
        frameLocalStackMarker.setUri(URI.create("locals"));
        this.localMarkers.push((ModuleElement)frameLocalStackMarker);
        this.frameStack.enterGlobal(FrameType.UNPROTECTED, (ModuleElement)frameLocalStackMarker, new Variable[0]);
    }

    private void restoreFrameStack() {
        this.frameStack.leaveGlobal(this.localMarkers.pop());
        this.frameStack.leaveGlobal(this.globalMarkers.pop());
    }

    void setModule() {
        this.context.setModule((IModule)this.getCurrent().template.getModule());
    }

    public void restore() {
        this.setModule();
        this.restoreFrameStack();
        this.specs.pop();
    }

    public ExecutableTemplateSpecification getCurrent() {
        return this.specs.peek();
    }

    public ExecutableTemplateSpecification getBase() {
        return this.firstSpec;
    }
}

