/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.IEgxModule;
import org.eclipse.epsilon.egl.execute.context.EgxModuleTemplateAdapter;
import org.eclipse.epsilon.egl.execute.context.IEgxContext;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.execute.context.ErlContext;

public class EgxContext
extends ErlContext
implements IEgxContext {
    private EgxModuleTemplateAdapter baseTemplate;
    private EglTemplateFactory templateFactory;
    protected Map<URI, EglTemplate> templateCache;
    protected Collection<Template> invokedTemplates;

    public EgxContext() {
        this((EglTemplateFactory)null);
    }

    public EgxContext(EglTemplateFactory templateFactory) {
        this.setTemplateFactory(templateFactory != null ? templateFactory : new EglTemplateFactory());
        this.invokedTemplates = new ArrayList<Template>();
        this.templateCache = new HashMap<URI, EglTemplate>();
    }

    public EgxContext(IEgxContext other) {
        super((IEolContext)other);
        this.templateFactory = other.getTemplateFactory();
        this.invokedTemplates = other.getInvokedTemplates();
        this.templateCache = other.getTemplateCache();
        if (other instanceof EgxContext) {
            this.baseTemplate = ((EgxContext)other).baseTemplate;
        }
    }

    public EgxModuleTemplateAdapter getTrace() {
        if (this.baseTemplate == null) {
            this.baseTemplate = new EgxModuleTemplateAdapter(this.getModule());
        }
        return this.baseTemplate;
    }

    public void setBaseTemplate(EgxModuleTemplateAdapter baseTemplate) {
        this.baseTemplate = baseTemplate;
    }

    @Override
    public IEgxModule getModule() {
        return (IEgxModule)super.getModule();
    }

    @Override
    public Collection<Template> getInvokedTemplates() {
        return this.invokedTemplates;
    }

    @Override
    public void setTemplateFactory(EglTemplateFactory templateFactory) {
        this.templateFactory = templateFactory;
        if (this.templateFactory != null) {
            templateFactory.copyState((IEolContext)this);
        }
    }

    @Override
    public EglTemplateFactory getTemplateFactory() {
        return this.templateFactory;
    }

    @Override
    public Map<URI, EglTemplate> getTemplateCache() {
        return this.templateCache;
    }

    public void dispose() {
        super.dispose();
        if (this.templateCache != null) {
            this.templateCache.clear();
        }
        if (this.invokedTemplates != null) {
            this.invokedTemplates.clear();
        }
    }
}

