/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.traceability.Variable;
import org.eclipse.epsilon.eol.execute.context.FrameStack;

class ExecutableTemplateSpecification {
    public final EglTemplate template;
    public final IOutputBuffer outputBuffer;

    public ExecutableTemplateSpecification(EglTemplate template, IOutputBuffer outputBuffer) {
        this.template = template;
        this.outputBuffer = outputBuffer;
    }

    public ExecutableTemplateSpecification(ExecutableTemplateSpecification other) {
        this.template = other.template;
        this.outputBuffer = other.outputBuffer;
    }

    public void addAsChild(ExecutableTemplateSpecification child) {
        this.template.getTemplate().add(child.template.getTemplate());
    }

    public void addVariablesTo(FrameStack frameStack) {
        frameStack.putGlobal(org.eclipse.epsilon.eol.execute.context.Variable.createReadOnlyVariable((String)"out", (Object)this.outputBuffer));
        for (Variable variable : this.template.getTemplate().getVariables()) {
            frameStack.put(variable.getName(), variable.getValue());
        }
    }

    public String toString() {
        return this.template.getTemplate().toString();
    }
}

