/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import java.util.List;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.config.ContentTypeRepository;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.merge.partition.CompositePartitioner;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.output.OutputBuffer;
import org.eclipse.epsilon.egl.status.StatusMessage;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.EolOperationFactory;

public interface IEglContext
extends IEolContext {
    public EglTemplateFactory getTemplateFactory();

    public CompositePartitioner getPartitioner();

    public void setPartitioner(CompositePartitioner var1);

    public ContentTypeRepository getContentTypeRepository();

    public void setContentTypeRepository(ContentTypeRepository var1);

    public void addStatusMessage(StatusMessage var1);

    public List<StatusMessage> getStatusMessages();

    public void enter(EglTemplate var1);

    public void exit();

    public EglTemplate getCurrentTemplate();

    public Template getTrace();

    public IOutputBuffer getOutputBuffer();

    public IEglModule getModule();

    default public IOutputBuffer newOutputBuffer() {
        return new OutputBuffer(this);
    }

    default public void formatWith(Formatter formatter) {
        this.getOutputBuffer().formatWith(formatter);
    }

    default public List<String> getPartitioningProblems() {
        return this.getPartitioner().partition(this.getOutputBuffer().toString()).getProblems();
    }

    default public boolean usePartitionerFor(String contentType) {
        CompositePartitioner partitioner = this.getContentTypeRepository().partitionerFor(contentType);
        if (partitioner == null) {
            return false;
        }
        this.setPartitioner(partitioner);
        return true;
    }

    default public void setDelegate(IEolContext delegate) {
        if (delegate == null) {
            return;
        }
        this.setIntrospectionManager(delegate.getIntrospectionManager());
        this.setModelRepository(delegate.getModelRepository());
        this.setUserInput(delegate.getUserInput());
        this.setNativeTypeDelegates(delegate.getNativeTypeDelegates());
        this.setExtendedProperties(delegate.getExtendedProperties());
        this.setPrettyPrinterManager(delegate.getPrettyPrinterManager());
        this.setErrorStream(delegate.getErrorStream());
        this.setOutputStream(delegate.getOutputStream());
        this.getExecutorFactory().setBase(delegate.getExecutorFactory());
        EolOperationFactory opf = delegate.getOperationFactory();
        if (this.getOperationFactory().getClass().isInstance(opf)) {
            this.setOperationFactory(opf);
        }
        if (delegate instanceof IEglContext) {
            IEglContext eglContext = (IEglContext)delegate;
            this.setPartitioner(eglContext.getPartitioner());
            this.setContentTypeRepository(eglContext.getContentTypeRepository());
        }
    }

    default public IEolContext getDelegate() {
        return null;
    }
}

