/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context.concurrent;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.IEgxModule;
import org.eclipse.epsilon.egl.execute.context.EgxContext;
import org.eclipse.epsilon.egl.execute.context.IEgxContext;
import org.eclipse.epsilon.egl.execute.context.concurrent.IEgxContextParallel;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.execute.context.concurrent.ErlContextParallel;

public class EgxContextParallel
extends ErlContextParallel
implements IEgxContextParallel {
    protected EglTemplateFactory templateFactory;
    protected Map<URI, EglTemplate> templateCache;
    protected Collection<Template> invokedTemplates;
    ThreadLocal<Map<URI, EglTemplate>> concurrentTemplateCaches;

    public EgxContextParallel() {
        this(null);
    }

    public EgxContextParallel(EglTemplateFactory templateFactory) {
        this(templateFactory, 0);
    }

    public EgxContextParallel(int parallelism) {
        this(null, parallelism);
    }

    public EgxContextParallel(EglTemplateFactory templateFactory, int parallelism) {
        super(parallelism);
        this.setTemplateFactory(templateFactory != null ? templateFactory : new EglTemplateFactory());
        this.invokedTemplates = ConcurrencyUtils.concurrentOrderedCollection();
    }

    protected IEgxContext createShadowThreadLocalContext() {
        return new EgxContext(this);
    }

    public IEgxContext getShadow() {
        return (IEgxContext)super.getShadow();
    }

    protected void initThreadLocals() {
        super.initThreadLocals();
        this.concurrentTemplateCaches = ThreadLocal.withInitial(HashMap::new);
    }

    protected synchronized void clearThreadLocals() {
        super.clearThreadLocals();
        this.removeAll(new ThreadLocal[]{this.concurrentTemplateCaches});
    }

    protected void nullifyThreadLocals() {
        super.nullifyThreadLocals();
        this.concurrentTemplateCaches = null;
    }

    @Override
    public void setTemplateFactory(EglTemplateFactory templateFactory) {
        this.templateFactory = templateFactory;
        if (this.templateFactory != null) {
            templateFactory.copyState((IEolContext)this);
        }
    }

    @Override
    public EglTemplateFactory getTemplateFactory() {
        return this.templateFactory;
    }

    @Override
    public Map<URI, EglTemplate> getTemplateCache() {
        return (Map)this.parallelGet(this.concurrentTemplateCaches, this.templateCache);
    }

    @Override
    public Collection<Template> getInvokedTemplates() {
        return this.invokedTemplates;
    }

    @Override
    public IEgxModule getModule() {
        return (IEgxModule)super.getModule();
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.templateCache != null) {
            this.templateCache.clear();
        }
        if (this.invokedTemplates != null) {
            this.invokedTemplates.clear();
        }
    }
}

