/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;
import org.eclipse.epsilon.eol.execute.operations.simple.SimpleOperation;

public class OutdentOperation
extends SimpleOperation {
    protected Set<String> ids = new HashSet<String>();
    protected List<IExecutionListener> executionListenersForRemoval = new ArrayList<IExecutionListener>();

    public Object execute(Object source, List<?> parameters, IEolContext context, ModuleElement ast) throws EolRuntimeException {
        for (IExecutionListener executionListener : this.executionListenersForRemoval) {
            context.getExecutorFactory().removeExecutionListener(executionListener);
        }
        final String id = String.valueOf(parameters.get(0));
        if (!this.ids.contains(id)) {
            final IOutputBuffer buffer = (IOutputBuffer)context.getFrameStack().get("out").getValue();
            buffer.getOutdentationFormatter().outdent(buffer.getLength());
            this.ids.add(id);
            final ModuleElement moduleElement = context.getFrameStack().getCurrentStatement().getParent();
            context.getExecutorFactory().addExecutionListener(new IExecutionListener(){

                public void finishedExecutingWithException(ModuleElement ast, EolRuntimeException exception, IEolContext context) {
                }

                public void finishedExecuting(ModuleElement ast, Object result, IEolContext context) {
                    if (ast == moduleElement && OutdentOperation.this.ids.contains(id)) {
                        buffer.getOutdentationFormatter().indent(buffer.getLength());
                        OutdentOperation.this.ids.remove(id);
                        OutdentOperation.this.executionListenersForRemoval.add(this);
                    }
                }

                public void aboutToExecute(ModuleElement ast, IEolContext context) {
                }
            });
        }
        return null;
    }
}

