/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.formatter.language;

import org.eclipse.epsilon.egl.formatter.CompositeFormatter;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.formatter.language.LanguageFormatter;
import org.eclipse.epsilon.egl.formatter.linebyline.Line;
import org.eclipse.epsilon.egl.formatter.linebyline.LineByLineFormatter;
import org.eclipse.epsilon.egl.formatter.linebyline.LineFactory;

public class PromelaFormatter
implements Formatter {
    private final CompositeFormatter composite = new CompositeFormatter(new PromelaBlockFormatter(), new PromelaIfBlockFormatter());

    @Override
    public String format(String text) {
        return this.composite.format(text);
    }

    static class PromelaBlockFormatter
    extends LanguageFormatter {
        private static final String increasePattern = "\\{";
        private static final String decreasePattern = "\\}";

        public PromelaBlockFormatter() {
            super(increasePattern, decreasePattern);
        }
    }

    static class PromelaIfBlockFormatter
    extends LineByLineFormatter<PromelaLine> {
        private boolean insideAnIfBlock = false;

        PromelaIfBlockFormatter() {
        }

        @Override
        protected LineFactory<PromelaLine> createLineFactory() {
            return new PromelaLineFactory();
        }

        @Override
        protected void formatLine() {
            if (((PromelaLine)this.navigator.getCurrentLine()).isStartOfIfBlock()) {
                this.insideAnIfBlock = true;
            } else if (((PromelaLine)this.navigator.getCurrentLine()).isEndOfAnIfBlock()) {
                this.insideAnIfBlock = false;
            }
            if (this.insideAnIfBlock) {
                this.formatContentsOfIfBlock();
            }
        }

        private void formatContentsOfIfBlock() {
            if (this.betweenTheEndOfOneCaseAndTheStartOfAnother()) {
                this.navigator.insertBeforeCurrentLine(new PromelaLine(""));
            } else if (((PromelaLine)this.navigator.getCurrentLine()).isMiddleOfACase()) {
                ((PromelaLine)this.navigator.getCurrentLine()).addPrefix("\t");
            }
        }

        private boolean betweenTheEndOfOneCaseAndTheStartOfAnother() {
            return ((PromelaLine)this.navigator.getCurrentLine()).isStartOfACase() && ((PromelaLine)this.navigator.getPreviousLine()).isMiddleOfACase();
        }

        static class PromelaLine
        extends Line {
            public PromelaLine(String rawLine) {
                super(rawLine);
            }

            public boolean isStartOfIfBlock() {
                return this.rawLine.trim().equals("if");
            }

            public boolean isEndOfAnIfBlock() {
                return this.rawLine.trim().equals("fi;");
            }

            public boolean isStartOfACase() {
                return this.rawLine.trim().startsWith("::");
            }

            public boolean isMiddleOfACase() {
                return !this.isStartOfACase() && !this.isStartOfIfBlock() && !this.isEndOfAnIfBlock();
            }
        }

        static class PromelaLineFactory
        implements LineFactory<PromelaLine> {
            PromelaLineFactory() {
            }

            @Override
            public PromelaLine createLine(String rawLine) {
                return new PromelaLine(rawLine);
            }
        }
    }
}

