/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.internal;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.Position;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.debug.BreakpointRequest;
import org.eclipse.epsilon.eol.debug.BreakpointResult;
import org.eclipse.epsilon.eol.debug.EolDebugger;

class EglDebugger
extends EolDebugger {
    private static final Logger LOGGER = Logger.getLogger(EglDebugger.class.getName());

    EglDebugger() {
    }

    public BreakpointResult verifyBreakpoint(BreakpointRequest request) {
        try {
            IModule resolvedModule = this.resolveModule(request.getUriToPathMappings(), request.getPath());
            if (resolvedModule != null) {
                Position actualPosition = null;
                Position requestedPosition = new Position(request.getLine(), request.getColumn() == null ? 0 : request.getColumn());
                if (resolvedModule instanceof IEolModule) {
                    IEolModule eolModule = (IEolModule)resolvedModule;
                    actualPosition = this.findFirstLineGreaterThanOrEqualTo((ModuleElement)eolModule.getMain(), requestedPosition);
                }
                if (actualPosition == null) {
                    actualPosition = this.findFirstLineGreaterThanOrEqualTo((ModuleElement)resolvedModule, requestedPosition);
                }
                if (actualPosition != null) {
                    return BreakpointResult.verified((BreakpointRequest)request, (IModule)resolvedModule, (int)actualPosition.getLine(), (Integer)actualPosition.getColumn());
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to verify breakpoint due to error: " + e.getMessage(), e);
        }
        return BreakpointResult.failed((BreakpointRequest)request);
    }
}

