/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.UriUtil;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.dom.TemplateOperation;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.exceptions.EglStoppedException;
import org.eclipse.epsilon.egl.execute.context.EglContext;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.internal.EglDebugger;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.model.EglMarkerSection;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.parse.EglLexer;
import org.eclipse.epsilon.egl.parse.EglParser;
import org.eclipse.epsilon.egl.parse.EglToken;
import org.eclipse.epsilon.egl.parse.problem.EglParseProblem;
import org.eclipse.epsilon.egl.preprocessor.Preprocessor;
import org.eclipse.epsilon.egl.types.EglComplexType;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.debug.EolDebugger;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolType;

public class EglModule
extends EolModule
implements IEglModule {
    protected EglParser eglParser;
    private final Preprocessor preprocessor = new Preprocessor();
    private final List<EglMarkerSection> markers = new LinkedList<EglMarkerSection>();
    private URI templateRoot;

    public EglModule() {
        this(null);
    }

    public EglModule(IEglContext context) {
        super((IEolContext)(context != null ? context : new EglContext()));
    }

    public void build(AST cst, IModule module) {
        if (cst.getParent() == null) {
            this.preprocessor.updateASTLocations(cst);
        }
        super.build(cst, module);
    }

    public boolean parse(String code, File file) throws Exception {
        this.sourceFile = file;
        if (this.sourceFile != null) {
            try {
                this.templateRoot = UriUtil.fileToUri((File)file.getAbsoluteFile().getParentFile());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return this.parseAndPreprocess(new EglLexer(code));
    }

    public boolean parse(URI uri) throws Exception {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        this.sourceUri = uri;
        this.templateRoot = uri;
        if (uri.getScheme() != null && uri.getScheme().equals("file")) {
            this.sourceFile = new File(uri);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(uri.toURL().openStream()));){
            return this.parseAndPreprocess(new EglLexer(reader));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean parseAndPreprocess(EglLexer lexer) throws Exception {
        EpsilonTreeAdaptor astFactory = new EpsilonTreeAdaptor(this.sourceFile, (IModule)this);
        this.eglParser = new EglParser(lexer, astFactory);
        this.eglParser.parse();
        AST ast = this.eglParser.getAST();
        if (this.eglParser.getParseProblems().isEmpty() && this.preprocess(ast)) {
            for (AST child : ast.getChildren()) {
                if (child.getType() != EglToken.TokenType.START_MARKER_TAG.getIdentifier()) continue;
                EglMarkerSection section = (EglMarkerSection)this.createAst(child, (ModuleElement)this);
                this.markers.add(section);
            }
            return true;
        }
        return false;
    }

    public ModuleElement adapt(AST cst, ModuleElement parentAst) {
        if (cst == null) {
            return this;
        }
        if (cst.getType() == EglToken.TokenType.START_MARKER_TAG.getIdentifier()) {
            return new EglMarkerSection();
        }
        if (cst.getType() == 32 && this.hasAnnotation(cst, "template")) {
            return new TemplateOperation();
        }
        ModuleElement ast = super.adapt(cst, parentAst);
        if (ast instanceof TypeExpression) {
            return new TypeExpression(){

                public EolType execute(IEolContext context) throws EolRuntimeException {
                    if ("Template".equals(this.getName())) {
                        return EglComplexType.Template;
                    }
                    return super.execute(context);
                }
            };
        }
        return ast;
    }

    @Override
    public List<EglMarkerSection> getMarkers() {
        return this.markers;
    }

    @Override
    public Object execute(EglTemplate template, Formatter postprocessor) throws EglRuntimeException {
        IEglContext context = this.getContext();
        context.enter(template);
        context.getTemplateFactory().initialiseRoot(this.templateRoot);
        try {
            super.execute();
        }
        catch (EolInternalException ex) {
            Throwable internal = ex.getInternal();
            if (!(internal instanceof EglStoppedException)) {
                if (internal instanceof EglRuntimeException) {
                    throw new EglRuntimeException(ex);
                }
                throw new EglRuntimeException((Throwable)ex);
            }
        }
        catch (EglRuntimeException ex) {
            throw ex;
        }
        catch (EolRuntimeException ex) {
            throw new EglRuntimeException(ex);
        }
        IOutputBuffer output = context.getOutputBuffer();
        output.formatWith(postprocessor);
        List<String> problems = context.getPartitioningProblems();
        if (!problems.isEmpty()) {
            throw new EglRuntimeException(problems.get(0), (ModuleElement)this);
        }
        String result = output.toString();
        context.exit();
        return result;
    }

    public List<ParseProblem> getParseProblems() {
        this.parseProblems.addAll(this.eglParser.getParseProblems());
        int index = 0;
        while (index < this.parseProblems.size()) {
            ParseProblem problem = (ParseProblem)this.parseProblems.get(index);
            if (!(problem instanceof EglParseProblem)) {
                this.parseProblems.set(index, new EglParseProblem(problem, this.preprocessor.getTrace()));
            }
            ++index;
        }
        return this.parseProblems;
    }

    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll((Collection<ModuleElement>)this.getDeclaredOperations());
        return children;
    }

    protected HashMap<String, Class<? extends IModule>> getImportConfiguration() {
        HashMap importConfiguration = super.getImportConfiguration();
        importConfiguration.put("egl", EglModule.class);
        return importConfiguration;
    }

    @Override
    public IEglContext getContext() {
        return (IEglContext)super.getContext();
    }

    protected boolean hasAnnotation(AST ast, String name) {
        if (ast.getAnnotationsAst() == null) {
            return false;
        }
        for (AST annotation : ast.getAnnotationsAst().getChildren()) {
            if (annotation.getType() != 27 || !annotation.getText().trim().equals("@" + name)) continue;
            return true;
        }
        return false;
    }

    protected boolean preprocess(AST ast) {
        String eol = this.preprocessor.convertToEol(ast);
        try {
            return super.parse(eol, this.sourceFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public EolDebugger createDebugger() {
        return new EglDebugger();
    }
}

