/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.launch;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.epsilon.egl.EglFileGeneratingTemplateFactory;
import org.eclipse.epsilon.egl.EglModule;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.IEglModule;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.eol.launch.EolRunConfiguration;

public class EglRunConfiguration
extends EolRunConfiguration {
    public final URI outputRoot;
    public final boolean persistOutput;

    public static Builder<? extends EglRunConfiguration, ?> Builder() {
        return new Builder(EglRunConfiguration.class);
    }

    public EglRunConfiguration(Builder<? extends EolRunConfiguration, ?> builder) {
        super(builder);
        Path output = builder.outputRoot;
        if (output == null) {
            output = (this.outputFile != null ? this.outputFile : this.script).getParent();
        }
        this.outputRoot = output.toUri();
        this.persistOutput = builder.persistOutput;
    }

    public EglRunConfiguration(EglRunConfiguration other) {
        super((EolRunConfiguration)other);
        this.outputRoot = other.outputRoot;
        this.persistOutput = other.persistOutput;
    }

    protected EglTemplateFactory getDefaultTemplateFactory() throws EglRuntimeException {
        EglTemplateFactory templateFactory = !this.persistOutput ? new EglTemplateFactory() : new EglFileGeneratingTemplateFactory(Paths.get(this.outputRoot));
        templateFactory.setTemplateRoot(this.script.getParent().toUri().toString());
        return templateFactory;
    }

    public void reset() throws Exception {
        this.getModule().reset();
        super.reset();
    }

    public IEglModule getModule() {
        return (IEglModule)super.getModule();
    }

    public static class Builder<R extends EglRunConfiguration, B extends Builder<R, B>>
    extends EolRunConfiguration.Builder<R, B> {
        public Path outputRoot;
        public boolean persistOutput = true;

        protected Builder() {
        }

        protected Builder(Class<R> runConfigClass) {
            super(runConfigClass);
        }

        protected IEglModule createModule() {
            if (this.isSequential()) {
                return new EglModule();
            }
            throw new IllegalStateException("Parallel EGL is not supported (yet)");
        }
    }
}

