/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.launch;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.epsilon.common.util.FileUtil;
import org.eclipse.epsilon.egl.EglFileGeneratingTemplateFactory;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.EgxModule;
import org.eclipse.epsilon.egl.IEgxModule;
import org.eclipse.epsilon.egl.concurrent.EgxModuleParallelAnnotation;
import org.eclipse.epsilon.egl.concurrent.EgxModuleParallelGenerationRuleAtoms;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.concurrent.EgxContextParallel;
import org.eclipse.epsilon.eol.launch.EolRunConfiguration;
import org.eclipse.epsilon.erl.launch.ErlRunConfiguration;

public class EgxRunConfiguration
extends ErlRunConfiguration {
    public final URI outputRoot;
    public final boolean persistOutput;
    public final boolean deleteBeforeRun;

    public static Builder<? extends EgxRunConfiguration, ?> Builder() {
        return new Builder(EgxRunConfiguration.class);
    }

    public EgxRunConfiguration(Builder<? extends EgxRunConfiguration, ?> builder) {
        super(builder);
        Path output = builder.outputRoot;
        if (output == null) {
            output = (this.outputFile != null ? this.outputFile : this.script).getParent();
        }
        this.outputRoot = output.toUri();
        this.persistOutput = builder.persistOutput;
        this.deleteBeforeRun = builder.deleteOutputDirBefore;
    }

    public EgxRunConfiguration(EgxRunConfiguration other) {
        super((EolRunConfiguration)other);
        this.outputRoot = other.outputRoot;
        this.persistOutput = other.persistOutput;
        this.deleteBeforeRun = other.deleteBeforeRun;
    }

    protected EglTemplateFactory getDefaultTemplateFactory() throws EglRuntimeException {
        EglTemplateFactory templateFactory = !this.persistOutput ? new EglTemplateFactory() : new EglFileGeneratingTemplateFactory(Paths.get(this.outputRoot));
        templateFactory.setTemplateRoot(this.script.getParent().toUri().toString());
        return templateFactory;
    }

    public IEgxModule getModule() {
        return (IEgxModule)super.getModule();
    }

    public void preExecute() throws Exception {
        this.getModule().getContext().setTemplateFactory(this.getDefaultTemplateFactory());
        if (this.deleteBeforeRun && !this.persistOutput) {
            FileUtil.deleteDirectory((Path)Paths.get(this.outputRoot));
        }
        super.preExecute();
    }

    public static class Builder<C extends EgxRunConfiguration, B extends Builder<C, B>>
    extends ErlRunConfiguration.Builder<C, B> {
        public Path outputRoot;
        public boolean persistOutput = true;
        public boolean deleteOutputDirBefore = false;

        public B withoutPersistence() {
            return this.withPersistence(false);
        }

        public B withPersistence(boolean persist) {
            this.persistOutput = persist;
            return (B)((Object)this);
        }

        public B withFreshOutputDir() {
            return this.withFreshOutputDir(true);
        }

        public B withFreshOutputDir(boolean deleteBeforeRun) {
            this.deleteOutputDirBefore = deleteBeforeRun;
            return (B)((Object)this);
        }

        public B withOutputRoot(String output) {
            return this.withOutputRoot(Paths.get(output, new String[0]));
        }

        public B withOutputRoot(Path output) {
            this.outputRoot = output;
            return (B)((Object)this);
        }

        protected Builder() {
        }

        protected Builder(Class<C> runConfigClass) {
            super(runConfigClass);
        }

        protected IEgxModule createModule() {
            if (this.isSequential()) {
                return new EgxModule();
            }
            EgxContextParallel context = new EgxContextParallel(this.parallelism);
            return this.isParallel() ? new EgxModuleParallelGenerationRuleAtoms(context) : new EgxModuleParallelAnnotation(context);
        }
    }
}

