/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.egl.merge.output.LocatedRegion;
import org.eclipse.epsilon.egl.merge.output.Output;
import org.eclipse.epsilon.egl.merge.output.RegionType;
import org.eclipse.epsilon.egl.merge.partition.Partitioner;
import org.eclipse.epsilon.egl.status.ProtectedRegionWarning;

public class Merger {
    protected final Partitioner partitioner;
    protected final Output generated;
    protected final Output existing;
    protected final List<ProtectedRegionWarning> warnings = new LinkedList<ProtectedRegionWarning>();

    public Merger(Partitioner partitioner, String generated, String existing) {
        this.partitioner = partitioner;
        this.generated = partitioner.partition(generated);
        this.existing = partitioner.partition(existing);
    }

    public List<ProtectedRegionWarning> getMergeWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public String merge() {
        this.warnings.clear();
        boolean hasControlledRegions = false;
        for (LocatedRegion region : this.generated.getLocatedRegions()) {
            if (region.getType() == RegionType.Protected) break;
            if (region.getType() != RegionType.Controlled) continue;
            hasControlledRegions = true;
            break;
        }
        if (hasControlledRegions) {
            return this.mergeControlledRegions();
        }
        return this.mergeProtectedRegions();
    }

    public String mergeControlledRegions() {
        for (LocatedRegion existingRegion : this.existing.getLocatedRegions()) {
            if (existingRegion == null) continue;
            LocatedRegion generatedRegion = this.generated.getLocatedRegion(existingRegion.getId());
            if (!existingRegion.isEnabled() || existingRegion.getType() != RegionType.Controlled) continue;
            generatedRegion.setEnabled(true);
            existingRegion.setContents(generatedRegion.getContents());
        }
        return this.existing.toString();
    }

    public String mergeProtectedRegions() {
        this.warnings.clear();
        HashSet<String> idsPresentInGenerated = new HashSet<String>();
        for (LocatedRegion generatedRegion : this.generated.getLocatedRegions()) {
            LocatedRegion existingRegion = this.existing.getLocatedRegion(generatedRegion.getId());
            idsPresentInGenerated.add(generatedRegion.getId());
            if (existingRegion == null || !existingRegion.isEnabled() || existingRegion.getType() != RegionType.Protected) continue;
            generatedRegion.setEnabled(true);
            generatedRegion.setContents(existingRegion.getContents());
        }
        for (LocatedRegion existingRegion : this.existing.getLocatedRegions()) {
            if (idsPresentInGenerated.contains(existingRegion.getId())) continue;
            this.warnings.add(new ProtectedRegionWarning(existingRegion.getId()));
        }
        return this.generated.toString();
    }
}

