/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge.output;

import org.eclipse.epsilon.egl.merge.output.Region;
import org.eclipse.epsilon.egl.merge.output.RegionType;

public abstract class LocatedRegion
extends Region {
    private final String id;
    private final int offset;
    private final String defaultValue;
    protected RegionType type = RegionType.Regular;
    private boolean enabled;

    protected LocatedRegion(String id, int offset) {
        this(id, offset, true);
    }

    protected LocatedRegion(String id, int offset, boolean enabled) {
        this(id, offset, enabled, "");
    }

    protected LocatedRegion(String id, int offset, boolean enabled, String contents) {
        super(contents);
        if (id == null) {
            throw new NullPointerException("id must not be null");
        }
        this.id = id;
        this.offset = offset;
        this.enabled = enabled;
        this.defaultValue = contents;
        this.type = RegionType.Protected;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public abstract String toString();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocatedRegion)) {
            return false;
        }
        LocatedRegion that = (LocatedRegion)o;
        return this.id.equals(that.id) && this.offset == that.offset && this.enabled == that.enabled && this.type == that.type;
    }

    public RegionType getType() {
        return this.type;
    }

    public void setType(RegionType type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result += 37 * result + this.id.hashCode();
        result += 37 * result + this.offset;
        result += 37 * result + (this.enabled ? 1 : 0);
        return result;
    }
}

