/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.epsilon.egl.merge.output.LocatedRegion;
import org.eclipse.epsilon.egl.merge.output.Region;

public class Output {
    private final List<Region> regions = new ArrayList<Region>(0);
    private final Collection<String> duplicatedLocatedRegionIds = new LinkedHashSet<String>();
    private final Map<String, LocatedRegion> locatedRegions = new HashMap<String, LocatedRegion>();

    public Output(Region ... regions) {
        this(Arrays.asList(regions));
    }

    public Output(Collection<? extends Region> regions) {
        this.regions.addAll(regions);
        this.processIds();
    }

    private void processIds() {
        for (Region r : this.regions) {
            if (!(r instanceof LocatedRegion)) continue;
            LocatedRegion lr = (LocatedRegion)r;
            String id = lr.getId();
            if (this.locatedRegions.containsKey(id)) {
                this.duplicatedLocatedRegionIds.add(id);
                continue;
            }
            this.locatedRegions.put(id, lr);
        }
    }

    public List<Region> getRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    public List<LocatedRegion> getLocatedRegions() {
        return this.regions.stream().filter(LocatedRegion.class::isInstance).map(LocatedRegion.class::cast).collect(Collectors.toList());
    }

    public LocatedRegion getLocatedRegion(String id) {
        return this.locatedRegions.get(id);
    }

    public List<String> getProblems() {
        ArrayList<String> problems = new ArrayList<String>(this.duplicatedLocatedRegionIds.size());
        for (String id : this.duplicatedLocatedRegionIds) {
            problems.add("Output contains more than one region with the identifier '" + id + "'");
        }
        return Collections.unmodifiableList(problems);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Region region : this.regions) {
            builder.append(region);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Output)) {
            return false;
        }
        Output that = (Output)o;
        return Objects.equals(this.regions, that.regions);
    }

    public int hashCode() {
        return Objects.hashCode(this.regions);
    }
}

