/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge.partition;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epsilon.egl.merge.output.LocatedRegion;
import org.eclipse.epsilon.egl.merge.output.Output;
import org.eclipse.epsilon.egl.merge.output.Region;
import org.eclipse.epsilon.egl.merge.output.RegionType;
import org.eclipse.epsilon.egl.merge.partition.Partitioner;
import org.eclipse.epsilon.egl.util.FileUtil;

public class CommentBlockPartitioner
implements Partitioner {
    private static final int GROUP_REGION_TYPE = 1;
    private static final int GROUP_REGION_ID = 1;
    private static final int GROUP_END = 3;
    private static final int GROUP_ON_OR_OFF = 4;
    private final String startComment;
    private final String endComment;
    private final Pattern regionPattern;
    private final Pattern regionIdPattern;

    private static String escape(String text) {
        return text.replaceAll("\\*", "\\\\*");
    }

    public CommentBlockPartitioner(String startComment, String endComment) {
        this.startComment = startComment == null ? "" : startComment;
        this.endComment = endComment == null ? "" : endComment;
        this.regionPattern = this.initRegionPattern();
        this.regionIdPattern = this.initRegionIdPattern();
    }

    protected Pattern initRegionPattern() {
        StringBuilder regex = new StringBuilder();
        if (this.startComment.length() > 0) {
            regex.append(CommentBlockPartitioner.escape(this.startComment));
            regex.append("[\\s]*");
        }
        regex.append("(controlled|protected) region ");
        return Pattern.compile(regex.toString());
    }

    protected Pattern initRegionIdPattern() {
        StringBuilder regex = new StringBuilder();
        regex.append("(.*) ");
        regex.append("((end)");
        if (this.endComment.length() > 0) {
            regex.append("[\\s]*");
            regex.append(CommentBlockPartitioner.escape(this.endComment));
        }
        regex.append("|(on|off) begin");
        if (this.endComment.length() > 0) {
            regex.append("[\\s]*");
            regex.append(CommentBlockPartitioner.escape(this.endComment));
        }
        regex.append("[\\s]*$)");
        return Pattern.compile(regex.toString());
    }

    public String getStartComment() {
        return this.startComment;
    }

    public String getEndComment() {
        return this.endComment;
    }

    public String getFirstLine(String id, boolean enabled, RegionType regionType) {
        StringBuilder builder = new StringBuilder();
        if (this.startComment.length() > 0) {
            builder.append(this.startComment).append(' ');
        }
        builder.append(String.valueOf(this.regionTypeToString(regionType)) + " region ").append(id).append(" ").append(enabled ? "on" : "off").append(" begin");
        if (this.endComment.length() > 0) {
            builder.append(' ').append(this.endComment);
        }
        return builder.toString();
    }

    protected String regionTypeToString(RegionType regionType) {
        if (regionType == RegionType.Controlled) {
            return "controlled";
        }
        return "protected";
    }

    protected RegionType regionTypeFromString(String regionType) {
        if ("controlled".equals(regionType)) {
            return RegionType.Controlled;
        }
        return RegionType.Protected;
    }

    public String getLastLine(String id, RegionType regionType) {
        StringBuilder builder = new StringBuilder();
        if (this.startComment.length() > 0) {
            builder.append(this.startComment).append(' ');
        }
        builder.append(String.valueOf(this.regionTypeToString(regionType)) + " region ").append(id).append(" end");
        if (this.endComment.length() > 0) {
            builder.append(' ').append(this.endComment);
        }
        return builder.toString();
    }

    @Override
    public Output partition(String text) {
        return this.partition(text, 0);
    }

    @Override
    public Output partition(String text, int offset) {
        LinkedList<Region> regions = new LinkedList<Region>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Scanner scanner = new Scanner(text);){
            StringBuilder buffer = new StringBuilder();
            boolean isRegionEnabled = false;
            String regionId = null;
            RegionType regionType = null;
            int regionOffset = 0;
            int textOffset = 0;
            while (scanner.hasNextLine()) {
                List<RegionMatch> regionMatches;
                String line = scanner.nextLine();
                int currentLineOffset = 0;
                if (scanner.hasNextLine() || text.endsWith(FileUtil.NEWLINE)) {
                    line = String.valueOf(line) + FileUtil.NEWLINE;
                }
                if ((regionMatches = this.findRegionsInLine(line)).isEmpty()) {
                    buffer.append(line);
                } else {
                    int i = 0;
                    while (i < regionMatches.size()) {
                        int regionIdEndIndex;
                        RegionMatch regionMatch = regionMatches.get(i);
                        RegionMatch nextRegionMatch = i + 1 < regionMatches.size() ? regionMatches.get(i + 1) : null;
                        int regionStartIndex = regionMatch.getStart();
                        int regionIdStartIndex = regionMatch.getEnd();
                        int n = regionIdEndIndex = nextRegionMatch == null ? line.length() : nextRegionMatch.getStart();
                        if (currentLineOffset < regionStartIndex) {
                            buffer.append(line.substring(currentLineOffset, regionStartIndex));
                        }
                        currentLineOffset = regionStartIndex;
                        String regionIdSegment = line.substring(regionIdStartIndex, regionIdEndIndex);
                        Matcher regionIdMatcher = this.regionIdPattern.matcher(regionIdSegment);
                        if (regionIdMatcher.find()) {
                            if ("end".equals(regionIdMatcher.group(3))) {
                                String regionContents = buffer.toString();
                                buffer.setLength(0);
                                CommentedProtectedRegion region = new CommentedProtectedRegion(regionId, regionOffset, isRegionEnabled, regionContents);
                                region.setType(regionType);
                                regions.add(region);
                                currentLineOffset = regionIdStartIndex + regionIdMatcher.end();
                            } else {
                                isRegionEnabled = "on".equals(regionIdMatcher.group(4));
                                regionId = regionIdMatcher.group(1);
                                regionType = regionMatch.getRegionType();
                                regionOffset = offset + textOffset + currentLineOffset;
                                if (buffer.length() > 0) {
                                    regions.add(new Region(buffer.toString()));
                                    buffer.setLength(0);
                                }
                                currentLineOffset = regionIdStartIndex + regionIdMatcher.end() + FileUtil.NEWLINE.length();
                            }
                        }
                        ++i;
                    }
                    if (currentLineOffset < line.length()) {
                        buffer.append(line.substring(currentLineOffset));
                    }
                }
                textOffset += line.length();
            }
            if (buffer.length() > 0) {
                regions.add(new Region(buffer.toString()));
                buffer.setLength(0);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new Output(regions);
    }

    private List<RegionMatch> findRegionsInLine(String line) {
        Matcher regionMatcher = this.regionPattern.matcher(line);
        LinkedList<RegionMatch> regionMatches = new LinkedList<RegionMatch>();
        while (regionMatcher.find()) {
            regionMatches.add(new RegionMatch(regionMatcher));
        }
        return regionMatches;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{start=\"" + this.startComment + "\", " + "end=\"" + this.endComment + "\"}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CommentBlockPartitioner)) {
            return false;
        }
        CommentBlockPartitioner that = (CommentBlockPartitioner)o;
        return Objects.equals(this.startComment, that.startComment) && Objects.equals(this.endComment, that.endComment);
    }

    public int hashCode() {
        return Objects.hash(this.startComment, this.endComment);
    }

    class CommentedProtectedRegion
    extends LocatedRegion {
        CommentedProtectedRegion(String id, int offset, boolean enabled, String contents) {
            super(id, offset, enabled, contents);
        }

        @Override
        public String toString() {
            String result = String.valueOf(CommentBlockPartitioner.this.getFirstLine(this.getId(), this.isEnabled(), this.type)) + FileUtil.NEWLINE;
            result = String.valueOf(result) + (this.isEnabled() ? this.getContents() : this.getDefaultValue());
            result = String.valueOf(result) + CommentBlockPartitioner.this.getLastLine(this.getId(), this.type);
            return result;
        }
    }

    class RegionMatch {
        protected final int start;
        protected final int end;
        protected final RegionType regionType;

        public RegionMatch(Matcher matcher) {
            this.start = matcher.start();
            this.end = matcher.end();
            this.regionType = CommentBlockPartitioner.this.regionTypeFromString(matcher.group(1));
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        public RegionType getRegionType() {
            return this.regionType;
        }
    }
}

