/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge.partition;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import org.eclipse.epsilon.egl.merge.output.LocatedRegion;
import org.eclipse.epsilon.egl.merge.output.Output;
import org.eclipse.epsilon.egl.merge.output.Region;
import org.eclipse.epsilon.egl.merge.partition.CommentBlockPartitioner;
import org.eclipse.epsilon.egl.merge.partition.Partitioner;

public class CompositePartitioner
implements Partitioner {
    private final Set<CommentBlockPartitioner> partitioners = Collections.synchronizedSet(new LinkedHashSet());

    public CompositePartitioner(CommentBlockPartitioner ... partitioners) {
        CommentBlockPartitioner[] commentBlockPartitionerArray = partitioners;
        int n = partitioners.length;
        int n2 = 0;
        while (n2 < n) {
            CommentBlockPartitioner partitioner = commentBlockPartitionerArray[n2];
            this.addPartitioner(partitioner);
            ++n2;
        }
    }

    public void addPartitioner(CommentBlockPartitioner partitioner) {
        if (partitioner == null) {
            throw new NullPointerException("partitioner cannot be null");
        }
        this.partitioners.add(partitioner);
    }

    public Set<CommentBlockPartitioner> getPartitioners() {
        return this.partitioners;
    }

    @Override
    public Output partition(String text) {
        return this.partition(text, 0);
    }

    @Override
    public Output partition(String text, int offset) {
        LinkedList<Region> regions = new LinkedList<Region>();
        regions.add(new Region(text));
        for (CommentBlockPartitioner partitioner : this.partitioners) {
            int currentOffset = offset;
            int index = 0;
            while (index < regions.size()) {
                Region region = (Region)regions.get(index);
                if (!(region instanceof LocatedRegion)) {
                    Output output = partitioner.partition(region.getContents(), currentOffset);
                    if (output.getLocatedRegions().size() > 0) {
                        regions.remove(index);
                        regions.addAll(index, output.getRegions());
                        for (Region r : output.getRegions()) {
                            currentOffset += r.toString().length();
                        }
                        index += output.getRegions().size() - 1;
                    } else {
                        currentOffset += region.toString().length();
                    }
                } else {
                    currentOffset += region.toString().length();
                }
                ++index;
            }
        }
        return new Output(regions);
    }

    public CommentBlockPartitioner getDefaultPartitioner() {
        return this.partitioners.isEmpty() ? null : this.partitioners.iterator().next();
    }

    public String toString() {
        return Objects.toString(this.partitioners);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositePartitioner)) {
            return false;
        }
        CompositePartitioner that = (CompositePartitioner)o;
        return Objects.equals(this.partitioners, that.partitioners);
    }

    public int hashCode() {
        return Objects.hashCode(this.partitioners);
    }
}

