/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.output;

import java.util.Collection;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.exceptions.EglStoppedException;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.output.OutdentationFormatter;
import org.eclipse.epsilon.egl.util.FileUtil;

public interface IOutputBuffer {
    public void chop(int var1);

    public void print(Object var1);

    public void println();

    default public void println(Object o) {
        this.print(o);
        this.println();
    }

    public void printdyn(Object var1);

    default public void prinx(Object o) {
        this.print(o);
    }

    default public String getSpaces(int howMany) {
        String str = "";
        int i = 0;
        while (i < howMany) {
            str = String.valueOf(str) + " ";
            ++i;
        }
        return str;
    }

    public void setContentType(String var1) throws EglRuntimeException;

    default public String preserve(String id, boolean enabled, String contents) throws EglRuntimeException {
        return String.valueOf(this.startPreserve(id, enabled)) + this.getNewline() + contents + this.getNewline() + this.stopPreserve();
    }

    default public String preserve(String startComment, String endComment, String id, boolean enabled, String contents) throws EglRuntimeException {
        return String.valueOf(this.startPreserve(startComment, endComment, id, enabled)) + this.getNewline() + contents + this.getNewline() + this.stopPreserve();
    }

    public String startPreserve(String var1, boolean var2) throws EglRuntimeException;

    public String startPreserve(String var1, String var2, String var3, boolean var4) throws EglRuntimeException;

    public String stopPreserve() throws EglRuntimeException;

    default public String control(String id, boolean enabled, String contents) throws EglRuntimeException {
        return String.valueOf(this.startControl(id, enabled)) + this.getNewline() + contents + this.getNewline() + this.stopPreserve();
    }

    default public String control(String startComment, String endComment, String id, boolean enabled, String contents) throws EglRuntimeException {
        return String.valueOf(this.startControl(startComment, endComment, id, enabled)) + this.getNewline() + contents + this.getNewline() + this.stopPreserve();
    }

    public String startControl(String var1, boolean var2) throws EglRuntimeException;

    public String startControl(String var1, String var2, String var3, boolean var4) throws EglRuntimeException;

    public String stopControl() throws EglRuntimeException;

    public void stop() throws EglStoppedException;

    public int getCurrentLineNumber();

    default public int getCurrentColumnNumber() {
        String newLine;
        String text = this.toString();
        if (text.endsWith(newLine = this.getNewline())) {
            return 1;
        }
        String[] lines = text.split(newLine);
        return lines[lines.length - 1].length() + 1;
    }

    public int getOffset();

    public void formatWith(Formatter var1);

    public OutdentationFormatter getOutdentationFormatter();

    public String toString();

    default public String getNewline() {
        return FileUtil.NEWLINE;
    }

    public void setIndenters(Collection<String> var1);

    public Collection<String> getIndenters();

    public IOutputBuffer getParent();

    public void setParent(IOutputBuffer var1);

    default public int getLength() {
        return this.toString().length();
    }
}

