/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.output.OutputBuffer;

public class OutdentationFormatter
implements Formatter {
    protected int outdentation = 0;
    protected Map<Integer, Integer> outdentations = new LinkedHashMap<Integer, Integer>();
    protected OutputBuffer outputBuffer;

    public OutdentationFormatter(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    @Override
    public String format(String text) {
        if (this.outdentations.isEmpty()) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        int startOffset = 0;
        if (this.outdentations.get(text.length()) == null) {
            this.outdentations.put(text.length(), 0);
        }
        ArrayList<Integer> offsets = new ArrayList<Integer>(this.outdentations.keySet());
        Collections.sort(offsets);
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int offset = (Integer)iterator.next();
            String toOutdent = text.substring(startOffset, offset);
            int outdentation = this.outdentations.containsKey(startOffset) ? this.outdentations.get(startOffset) : 0;
            Scanner scanner = new Scanner(toOutdent);
            while (scanner.hasNextLine()) {
                buffer.append(this.outdent(scanner.nextLine(), outdentation));
                if (!scanner.hasNextLine() && !toOutdent.endsWith(this.outputBuffer.getNewline())) continue;
                buffer.append(this.outputBuffer.getNewline());
            }
            scanner.close();
            startOffset = offset;
        }
        return buffer.toString();
    }

    protected String outdent(String line, int outdentation) {
        int i = 0;
        while (i < outdentation) {
            String l = line;
            String indenter = this.outputBuffer.getIndenters().stream().filter(in -> l.startsWith((String)in)).findAny().orElse(null);
            if (indenter != null) {
                line = line.substring(indenter.length(), line.length());
            }
            ++i;
        }
        return line;
    }

    public void outdent(int offset) {
        ++this.outdentation;
        this.outdentations.put(offset, this.outdentation);
    }

    public void indent(int offset) {
        --this.outdentation;
        this.outdentations.put(offset, this.outdentation);
    }
}

