/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.output;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.exceptions.EglStoppedException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.CompositeFormatter;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.merge.output.RegionType;
import org.eclipse.epsilon.egl.merge.partition.CommentBlockPartitioner;
import org.eclipse.epsilon.egl.merge.partition.CompositePartitioner;
import org.eclipse.epsilon.egl.output.IOutputBuffer;
import org.eclipse.epsilon.egl.output.OutdentationFormatter;
import org.eclipse.epsilon.egl.status.Warning;

public class OutputBuffer
implements IOutputBuffer {
    protected StringBuffer buffer = new StringBuffer();
    protected IEglContext context;
    Pattern newLinePattern;
    protected List<CommentBlockPartitioner> customPartitioners = new LinkedList<CommentBlockPartitioner>();
    protected boolean contentTypeSet = false;
    protected String lastLine = null;
    protected boolean hasProtectedRegions = false;
    protected boolean hasControlledRegions = false;
    protected OutdentationFormatter outdentationFormatter = new OutdentationFormatter(this);
    protected Collection<String> indenters = Arrays.asList("\t", "    ");
    protected IOutputBuffer parent = null;

    public OutputBuffer(IEglContext context) {
        this(context, null);
    }

    public OutputBuffer() {
        this(null, null);
    }

    OutputBuffer(IEglContext context, String contents) {
        this.context = context;
        if (contents != null) {
            this.buffer.append(contents);
        }
    }

    @Override
    public void chop(int chars) {
        int limit = Math.min(chars, this.buffer.length());
        int i = 0;
        while (i < limit) {
            this.buffer.deleteCharAt(this.buffer.length() - 1);
            ++i;
        }
    }

    @Override
    public void print(Object o) {
        this.buffer.append(Objects.toString(o));
    }

    @Override
    public void printdyn(Object o) {
        String indentation = this.calculateIndentationToMatch(this.getLastLineInBuffer());
        String newLine = this.getNewline();
        String[] lines = StringUtil.toString((Object)o).split(newLine);
        int i = 0;
        while (i < lines.length) {
            if (i == 0) {
                this.buffer.append(lines[i]);
            } else {
                this.buffer.append(String.valueOf(newLine) + indentation + lines[i]);
            }
            ++i;
        }
    }

    public String getLastLineInBuffer() {
        int indexOfLastLine = this.buffer.lastIndexOf("\n");
        if (indexOfLastLine == -1) {
            return this.buffer.substring(0, this.buffer.length());
        }
        return this.buffer.substring(indexOfLastLine + 1, this.buffer.length());
    }

    public String calculateIndentationToMatch(String previousLine) {
        StringBuilder builder = new StringBuilder();
        char[] cArray = previousLine.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isWhitespace(c)) {
                builder.append(c);
            } else {
                builder.append(' ');
            }
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public void println() {
        this.buffer.append(this.getNewline());
    }

    @Override
    public void setContentType(String name) throws EglRuntimeException {
        if (this.contentTypeSet) {
            this.context.addStatusMessage(new Warning("Cannot set content type to '" + name + "' - content type already specified."));
        } else {
            if (!this.context.usePartitionerFor(name)) {
                throw new EglRuntimeException("'" + name + "' is not a recognised content type.", (ModuleElement)this.context.getModule());
            }
            CompositePartitioner partitioner = this.context.getPartitioner();
            for (CommentBlockPartitioner customPartitioner : this.customPartitioners) {
                partitioner.addPartitioner(customPartitioner);
            }
            this.contentTypeSet = true;
        }
    }

    @Override
    public String startPreserve(String id, boolean enabled) throws EglRuntimeException {
        return this.startLocate(id, enabled, RegionType.Protected);
    }

    @Override
    public String startControl(String id, boolean enabled) throws EglRuntimeException {
        return this.startLocate(id, enabled, RegionType.Controlled);
    }

    public String startLocate(String id, boolean enabled, RegionType regionType) throws EglRuntimeException {
        this.assertNoMixedRegions(regionType);
        if (this.lastLine != null) {
            throw new EglRuntimeException("The current region must be stopped before another region may begin.", (ModuleElement)this.context.getModule());
        }
        CompositePartitioner partitioner = this.context.getPartitioner();
        if (partitioner.getDefaultPartitioner() == null) {
            throw new EglRuntimeException("A content type must be specified before using startPreserve(id, enabled).", (ModuleElement)this.context.getModule());
        }
        this.lastLine = partitioner.getDefaultPartitioner().getLastLine(id, regionType);
        return partitioner.getDefaultPartitioner().getFirstLine(id, enabled, regionType);
    }

    @Override
    public String startControl(String startComment, String endComment, String id, boolean enabled) throws EglRuntimeException {
        return this.startLocate(startComment, endComment, id, enabled, RegionType.Controlled);
    }

    @Override
    public String startPreserve(String startComment, String endComment, String id, boolean enabled) throws EglRuntimeException {
        return this.startLocate(startComment, endComment, id, enabled, RegionType.Protected);
    }

    public String startLocate(String startComment, String endComment, String id, boolean enabled, RegionType regionType) throws EglRuntimeException {
        this.assertNoMixedRegions(regionType);
        if (this.lastLine != null) {
            throw new EglRuntimeException("The current region must be stopped before another region may begin.", (ModuleElement)this.context.getModule());
        }
        CommentBlockPartitioner customPartitioner = new CommentBlockPartitioner(startComment, endComment);
        this.lastLine = customPartitioner.getLastLine(id, regionType);
        this.context.getPartitioner().addPartitioner(customPartitioner);
        this.customPartitioners.add(customPartitioner);
        return customPartitioner.getFirstLine(id, enabled, regionType);
    }

    protected void assertNoMixedRegions(RegionType regionType) throws EglRuntimeException {
        if (regionType == RegionType.Controlled) {
            this.hasControlledRegions = true;
        } else if (regionType == RegionType.Protected) {
            this.hasProtectedRegions = true;
        }
        if (this.hasControlledRegions && this.hasProtectedRegions) {
            throw new EglRuntimeException("Templates cannot contain both protected and controlled regions", (ModuleElement)this.context.getModule());
        }
    }

    @Override
    public String stopControl() throws EglRuntimeException {
        return this.stopLocate();
    }

    @Override
    public String stopPreserve() throws EglRuntimeException {
        return this.stopLocate();
    }

    public String stopLocate() throws EglRuntimeException {
        if (this.lastLine == null) {
            throw new EglRuntimeException("There is no current region to stop.", (ModuleElement)this.context.getModule());
        }
        String result = this.lastLine;
        this.lastLine = null;
        return result;
    }

    @Override
    public void stop() throws EglStoppedException {
        throw new EglStoppedException((ModuleElement)this.context.getModule());
    }

    @Override
    public int getCurrentLineNumber() {
        if (this.newLinePattern == null) {
            this.newLinePattern = Pattern.compile(this.getNewline());
        }
        Matcher newLineMatcher = this.newLinePattern.matcher(this.buffer.toString());
        int numberOfLines = 1;
        while (newLineMatcher.find()) {
            ++numberOfLines;
        }
        return numberOfLines;
    }

    @Override
    public int getOffset() {
        if (this.parent != null) {
            return this.parent.getOffset() + this.buffer.length();
        }
        return this.buffer.length();
    }

    @Override
    public void formatWith(Formatter formatter) {
        CompositeFormatter composite = new CompositeFormatter(this.outdentationFormatter, formatter);
        this.replaceContentsWith(composite.format(this.buffer.toString()));
    }

    protected void replaceContentsWith(String newContents) {
        this.buffer.setLength(0);
        this.buffer.append(newContents);
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public OutdentationFormatter getOutdentationFormatter() {
        return this.outdentationFormatter;
    }

    @Override
    public void setIndenters(Collection<String> indentation) {
        this.indenters = indentation;
    }

    @Override
    public Collection<String> getIndenters() {
        return this.indenters;
    }

    @Override
    public void setParent(IOutputBuffer parent) {
        this.parent = parent;
    }

    @Override
    public IOutputBuffer getParent() {
        return this.parent;
    }

    @Override
    public int getLength() {
        return this.buffer.length();
    }
}

