/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.patch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.epsilon.egl.patch.Line;
import org.eclipse.epsilon.egl.patch.Patch;
import org.eclipse.epsilon.egl.patch.TextBlock;

public class FilePatcher {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Usage: java -jar filepatcher.jar inputfile patchfile outputfile");
        }
        new FilePatcher().run(args[0], args[1], args[2]);
    }

    public void run(String inputPath, String patchPath, String targetPath) throws Exception {
        TextBlock input = new TextBlock(this.readFromPath(inputPath));
        Patch patch = new Patch(this.readFromPath(patchPath));
        if (!patch.validate().isEmpty()) {
            throw new Exception("Invalid patch");
        }
        TextBlock output = patch.apply(input);
        Throwable throwable = null;
        Object var8_9 = null;
        try (FileWriter targetWriter = new FileWriter(targetPath);){
            String joined = output.getLines().stream().map(Line::getText).collect(Collectors.joining(System.lineSeparator()));
            targetWriter.write(joined);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String[] readFromPath(String path) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(path));){
            ArrayList<String> lines = new ArrayList<String>();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            return lines.toArray(new String[lines.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

