/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.patch;

import org.eclipse.epsilon.egl.patch.LineType;

public class Line {
    protected LineType type;
    protected String text;
    protected int number;

    public Line(LineType type, String text, int number) {
        this.text = text;
        this.number = number;
        this.type = type;
    }

    public String getTrimmedText() {
        return this.getText().trim();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public LineType getType() {
        return this.type;
    }

    public void setType(LineType type) {
        this.type = type;
    }

    public boolean is(LineType type) {
        return this.type == type;
    }

    public boolean isNot(LineType type) {
        return this.type != type;
    }

    public String toString() {
        String prefix = "";
        switch (this.type) {
            case COMMENT: {
                prefix = "#";
                break;
            }
            case INSERT: {
                prefix = "+";
                break;
            }
            case REGULAR: {
                prefix = "";
                break;
            }
            case REMOVE: {
                prefix = "-";
                break;
            }
            case KEEP_WILDCARD: {
                prefix = "...";
                break;
            }
            case REMOVE_WILDCARD: {
                prefix = "---";
            }
        }
        return String.valueOf(prefix) + this.text;
    }
}

