/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.patch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.epsilon.egl.patch.Line;
import org.eclipse.epsilon.egl.patch.LineFactory;
import org.eclipse.epsilon.egl.patch.LineMap;
import org.eclipse.epsilon.egl.patch.LineType;
import org.eclipse.epsilon.egl.patch.Match;
import org.eclipse.epsilon.egl.patch.PatchValidationDiagnostic;
import org.eclipse.epsilon.egl.patch.TextBlock;

public class Patch
extends TextBlock {
    public Patch() {
        super(new String[0]);
    }

    public Patch(String ... lines) {
        super(new String[0]);
        LineFactory lineFactory = new LineFactory();
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].trim().isEmpty()) {
                this.lines.add(lineFactory.createLine(lines[i], i + 1));
            }
            ++i;
        }
    }

    public List<PatchValidationDiagnostic> validate() {
        ArrayList<PatchValidationDiagnostic> diagnostics = new ArrayList<PatchValidationDiagnostic>();
        for (Line line : this.lines) {
            if (!line.is(LineType.KEEP_WILDCARD)) continue;
            if (this.isFirstLine(line)) {
                diagnostics.add(new PatchValidationDiagnostic(line, "Wildcards are not allowed at the beginning of a patch"));
            } else if (this.isLastLine(line)) {
                diagnostics.add(new PatchValidationDiagnostic(line, "Wildcards are not allowed at the end of a patch"));
            }
            if (!this.isFirstLine(line) && this.getPreviousLine(line).is(LineType.KEEP_WILDCARD)) {
                diagnostics.add(new PatchValidationDiagnostic(line, "Consecutive wildcards are not allowed"));
            }
            if (this.isLastLine(line) || !this.getNextLine(line).is(LineType.KEEP_WILDCARD)) continue;
            diagnostics.add(new PatchValidationDiagnostic(line, "Consecutive wildcards are not allowed"));
        }
        return diagnostics;
    }

    public boolean isValid() {
        return this.validate().isEmpty();
    }

    public List<Match> match(TextBlock block) {
        Line startMatchBlockLine = null;
        ArrayList<Match> matches = new ArrayList<Match>();
        Patch keepsAndRemoves = this.keepsAndRemoves();
        if (keepsAndRemoves.getLines().isEmpty()) {
            return matches;
        }
        LineMap lineMap = new LineMap();
        Line blockLine = block.getFirstLine();
        Line patchLine = keepsAndRemoves.getFirstLine();
        while (blockLine != null) {
            if (patchLine.is(LineType.KEEP_WILDCARD) || patchLine.is(LineType.REMOVE_WILDCARD)) {
                Line matchLine = keepsAndRemoves.getNextLine(patchLine);
                if (matchLine == null) {
                    if (startMatchBlockLine == null) break;
                    while (blockLine != null) {
                        lineMap.put(patchLine, blockLine);
                        blockLine = block.getNextLine(blockLine);
                    }
                    matches.add(new Match(block, startMatchBlockLine, block.getLastLine(), this, lineMap));
                    break;
                }
                if (startMatchBlockLine == null) {
                    startMatchBlockLine = blockLine;
                }
                while (blockLine != null && !matchLine.getTrimmedText().contentEquals(blockLine.getTrimmedText())) {
                    lineMap.put(patchLine, blockLine);
                    blockLine = block.getNextLine(blockLine);
                }
                patchLine = matchLine;
                continue;
            }
            if (patchLine.getTrimmedText().contentEquals(blockLine.getTrimmedText())) {
                lineMap.put(patchLine, blockLine);
                if (startMatchBlockLine == null) {
                    startMatchBlockLine = blockLine;
                }
                if (keepsAndRemoves.isLastLine(patchLine)) {
                    matches.add(new Match(block, startMatchBlockLine, blockLine, this, lineMap));
                    patchLine = keepsAndRemoves.getFirstLine();
                    startMatchBlockLine = null;
                    lineMap = new LineMap();
                } else {
                    patchLine = keepsAndRemoves.getNextLine(patchLine);
                }
                blockLine = block.getNextLine(blockLine);
                continue;
            }
            blockLine = block.getNextLine(blockLine);
            patchLine = keepsAndRemoves.getFirstLine();
            startMatchBlockLine = null;
            lineMap = new LineMap();
        }
        return matches;
    }

    public boolean appliesTo(TextBlock block) {
        return this.match(block).size() > 0;
    }

    public TextBlock apply(TextBlock block) {
        List<Match> matches = this.match(block);
        if (matches.isEmpty()) {
            return block;
        }
        TextBlock merged = new TextBlock(new String[0]);
        Iterator<Match> matchIterator = matches.iterator();
        Match match = matchIterator.next();
        Line originalLine = block.getFirstLine();
        while (originalLine != null) {
            if (match != null && originalLine == match.getStartLine()) {
                for (Line patchLine : match.getPatch().getLines()) {
                    if (patchLine.is(LineType.COMMENT)) continue;
                    if (patchLine.is(LineType.KEEP_WILDCARD)) {
                        for (Line blockLine : match.getLineMap().get(patchLine)) {
                            merged.getLines().add(blockLine);
                        }
                        continue;
                    }
                    if (patchLine.is(LineType.REMOVE_WILDCARD) || !patchLine.isNot(LineType.REMOVE)) continue;
                    String text = patchLine.is(LineType.INSERT) ? patchLine.getText() : match.getLineMap().get(patchLine).get(0).getText();
                    merged.getLines().add(new Line(LineType.REGULAR, text, -1));
                }
                originalLine = block.getNextLine(match.getEndLine());
                if (matchIterator.hasNext()) {
                    match = matchIterator.next();
                    continue;
                }
                match = null;
                continue;
            }
            merged.getLines().add(originalLine);
            originalLine = block.getNextLine(originalLine);
        }
        return merged;
    }

    public Patch keepsAndRemoves() {
        Patch patch = new Patch();
        patch.getLines().addAll(this.getLines().stream().filter(l -> l.getType() == LineType.REGULAR || l.getType() == LineType.REMOVE || l.getType() == LineType.KEEP_WILDCARD || l.getType() == LineType.REMOVE_WILDCARD).collect(Collectors.toList()));
        return patch;
    }
}

