/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.patch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.egl.patch.Line;
import org.eclipse.epsilon.egl.patch.LineType;

public class TextBlock {
    protected List<Line> lines = new ArrayList<Line>();

    public TextBlock(String ... lines) {
        int i = 0;
        while (i < lines.length) {
            this.lines.add(new Line(LineType.REGULAR, lines[i], i + 1));
            ++i;
        }
    }

    protected Line getFirstLine() {
        if (this.lines.isEmpty()) {
            return null;
        }
        return this.lines.get(0);
    }

    protected Line getLastLine() {
        if (this.lines.isEmpty()) {
            return null;
        }
        return this.lines.get(this.lines.size() - 1);
    }

    public List<Line> getLines() {
        return this.lines;
    }

    protected boolean isFirstLine(Line line) {
        if (line == null) {
            return false;
        }
        return this.lines.indexOf(line) == 0;
    }

    protected boolean isLastLine(Line line) {
        if (line == null) {
            return false;
        }
        return this.lines.indexOf(line) == this.lines.size() - 1;
    }

    protected Line getPreviousLine(Line line) {
        if (this.isFirstLine(line)) {
            return null;
        }
        return this.lines.get(this.lines.indexOf(line) - 1);
    }

    protected Line getNextLine(Line line) {
        if (this.isLastLine(line)) {
            return null;
        }
        return this.lines.get(this.lines.indexOf(line) + 1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextBlock)) {
            return false;
        }
        TextBlock other = (TextBlock)obj;
        if (other.getLines().size() != this.getLines().size()) {
            return false;
        }
        int i = 0;
        while (i < this.getLines().size()) {
            if (!other.getLines().get(i).getTrimmedText().equals(this.getLines().get(i).getTrimmedText())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.getLines().toString();
    }
}

