/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.preprocessor;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import org.antlr.runtime.Token;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.Position;
import org.eclipse.epsilon.common.parse.Region;
import org.eclipse.epsilon.egl.parse.EglToken;
import org.eclipse.epsilon.egl.preprocessor.PreprocessorTrace;
import org.eclipse.epsilon.egl.util.FileUtil;
import org.eclipse.epsilon.egl.util.StringUtil;

public class Preprocessor {
    private StringBuffer eol = new StringBuffer();
    private final Map<Integer, Integer> colNumber = new TreeMap<Integer, Integer>();
    private PreprocessorTrace trace = new PreprocessorTrace();
    private AST child = null;
    private static final Pattern PATTERN_TO_ESCAPE = Pattern.compile("\\\\|[\r\n\t\b\f'\"]");
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$epsilon$egl$parse$EglToken$TokenType;

    private int getOffset(int lineNumber) {
        if (this.colNumber.containsKey(lineNumber)) {
            return this.colNumber.get(lineNumber);
        }
        return 0;
    }

    private void addToOffset(int lineNumber, int addend) {
        this.colNumber.put(lineNumber, this.getOffset(lineNumber) + addend);
    }

    private void updateOffset(int eglLineNumber, int correction, int textLength) {
        this.trace.incrementColumnCorrectionNumber(0, this.getOffset(eglLineNumber) + correction);
        this.addToOffset(eglLineNumber, correction + textLength + 2);
    }

    private void appendNewLineToEol(int eglLineNumber) {
        this.appendNewLineToEol(eglLineNumber, this.eol.length() > 0);
    }

    private void appendNewLineToEol(int eglLineNumber, boolean appendNewLine) {
        if (appendNewLine) {
            this.eol.append(FileUtil.NEWLINE);
        }
        this.trace.setEglLineNumberForCurrentEolLineNumber(eglLineNumber);
    }

    private boolean eolEndsWith(String suffix) {
        if (suffix.length() > this.eol.length()) {
            return false;
        }
        return this.eol.substring(this.eol.length() - suffix.length(), this.eol.length()).equals(suffix);
    }

    /*
     * Unable to fully structure code
     */
    public String convertToEol(AST ast) {
        this.eol = new StringBuffer();
        this.colNumber.clear();
        this.trace.reset();
        this.child = ast.getFirstChild();
        while (this.child != null) {
            switch (Preprocessor.$SWITCH_TABLE$org$eclipse$epsilon$egl$parse$EglToken$TokenType()[EglToken.TokenType.typeOf(this.child.getType()).ordinal()]) {
                case 8: 
                case 9: {
                    commentLength = this.child.getText().length();
                    current = this.child.getFirstChild();
                    while (current != null) {
                        commentLength += current.getText().length();
                        current = current.getNextSibling();
                    }
                    this.addToOffset(this.child.getLine(), commentLength);
                    this.gobbleNextIfNewLine();
                    break;
                }
                case 2: 
                case 3: {
                    isWhitespacePrecedingTagged = EglToken.TokenType.typeOf(this.child.getType()) != EglToken.TokenType.NEW_LINE && StringUtil.isWhitespace(this.child.getText()) != false && this.child.getNextSibling() != null && (EglToken.TokenType.typeOf(this.child.getNextSibling().getType()) == EglToken.TokenType.START_TAG || EglToken.TokenType.typeOf(this.child.getNextSibling().getType()) == EglToken.TokenType.START_COMMENT_TAG);
                    text = Preprocessor.normaliseNewLines(this.child.getText());
                    if (isWhitespacePrecedingTagged) ** GOTO lbl113
                    printCall = "out.prinx('";
                    this.appendNewLineToEol(this.child.getLine());
                    this.trace.incrementColumnCorrectionNumber(0, this.getOffset(this.child.getLine()) + -"out.prinx('".length());
                    escapedLine = new StringBuilder("out.prinx('");
                    escapingMatcher = Preprocessor.PATTERN_TO_ESCAPE.matcher(text);
                    previousEnd = 0;
                    while (escapingMatcher.find()) {
                        newRegion = text.substring(previousEnd, escapingMatcher.start());
                        escapedLine.append(newRegion);
                        var13_15 = toBeEscaped = escapingMatcher.group();
                        tmp = -1;
                        switch (var13_15.hashCode()) {
                            case 8: {
                                if (var13_15.equals("\b")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 9: {
                                if (var13_15.equals("\t")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 10: {
                                if (var13_15.equals("\n")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 12: {
                                if (var13_15.equals("\f")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 13: {
                                if (var13_15.equals("\r")) {
                                    tmp = 5;
                                }
                                break;
                            }
                            case 34: {
                                if (var13_15.equals("\"")) {
                                    tmp = 6;
                                }
                                break;
                            }
                            case 39: {
                                if (var13_15.equals("'")) {
                                    tmp = 7;
                                }
                                break;
                            }
                            case 92: {
                                if (var13_15.equals("\\")) {
                                    tmp = 8;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 8: {
                                replacement = "\\\\";
                                break;
                            }
                            case 5: {
                                replacement = "\\r";
                                break;
                            }
                            case 3: {
                                replacement = "\\n";
                                break;
                            }
                            case 2: {
                                replacement = "\\t";
                                break;
                            }
                            case 1: {
                                replacement = "\\b";
                                break;
                            }
                            case 4: {
                                replacement = "\\f";
                                break;
                            }
                            case 7: {
                                replacement = "\\'";
                                break;
                            }
                            case 6: {
                                replacement = "\\\"";
                                break;
                            }
                            default: {
                                replacement = toBeEscaped;
                            }
                        }
                        escapedLine.append(replacement);
                        this.trace.incrementColumnCorrectionNumber(escapedLine.toString().length(), toBeEscaped.length() - replacement.length());
                        previousEnd = escapingMatcher.end();
                    }
                    escapedLine.append(text.substring(previousEnd));
                    escapedLine.append("');");
                    this.eol.append(escapedLine.toString());
lbl113:
                    // 2 sources

                    this.addToOffset(this.child.getLine(), text.length());
                    break;
                }
                case 4: 
                case 5: {
                    v0 = this.child.hasChildren() ? EglToken.TokenType.typeOf(this.child.getLastChild().getType()) == EglToken.TokenType.END_OUTDENT_TAG : (outdent = false);
                    if (!this.eolEndsWith(FileUtil.NEWLINE)) {
                        this.appendNewLineToEol(this.child.getLine());
                    }
                    if (EglToken.TokenType.typeOf(this.child.getType()) == EglToken.TokenType.START_TAG) {
                        textAst = this.child.getFirstChild();
                        firstLine = true;
                        while (textAst != null && EglToken.TokenType.typeOf(textAst.getType()) != EglToken.TokenType.END_TAG && EglToken.TokenType.typeOf(textAst.getType()) != EglToken.TokenType.END_OUTDENT_TAG) {
                            if (EglToken.TokenType.typeOf(textAst.getType()) == EglToken.TokenType.NEW_LINE) {
                                if (EglToken.TokenType.typeOf(textAst.getNextSibling().getType()) != EglToken.TokenType.END_TAG && EglToken.TokenType.typeOf(textAst.getNextSibling().getType()) != EglToken.TokenType.END_OUTDENT_TAG) {
                                    this.appendNewLineToEol(textAst.getLine() + 1, true);
                                    firstLine = false;
                                }
                            } else {
                                correction = firstLine != false ? 2 : 0;
                                this.updateOffset(textAst.getLine(), correction, textAst.getText().length());
                                this.eol.append(textAst.getText());
                            }
                            textAst = textAst.getNextSibling();
                        }
                        this.gobbleNextIfNewLine();
                    } else {
                        this.updateOffset(this.child.getLine(), "[%=".length(), this.child.getFirstChild().getText().length());
                        printCall = "out.printdyn(";
                        this.trace.incrementColumnCorrectionNumber(0, -printCall.length());
                        this.eol.append(String.valueOf(printCall) + this.child.getFirstChild().getText() + ");");
                    }
                    if (!outdent) break;
                    this.eol.append("_outdent('" + UUID.randomUUID().toString() + "');");
                    break;
                }
            }
            this.child = this.child.getNextSibling();
        }
        return this.eol.toString();
    }

    private static String normaliseNewLines(String text) {
        return text.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n").replaceAll("\\n", FileUtil.NEWLINE);
    }

    private void gobbleNextIfNewLine() {
        boolean nextNodeIsNewLine;
        boolean bl = nextNodeIsNewLine = this.child.getNextSibling() != null && EglToken.TokenType.typeOf(this.child.getNextSibling().getType()) == EglToken.TokenType.NEW_LINE;
        if (nextNodeIsNewLine) {
            this.child = this.child.getNextSibling();
        }
    }

    public PreprocessorTrace getTrace() {
        return this.trace;
    }

    protected boolean updateRegionsOfStaticTextASTs(AST ast) {
        if (ast.getType() == 9 && ast.getNumberOfChildren() == 2) {
            AST firstParameterAst;
            AST parametersAst;
            AST outAst = ast.getFirstChild();
            AST printAst = ast.getChild(1);
            if ("out".equals(outAst.getText()) && ("prinx".equals(printAst.getText()) || "printdyn".equals(printAst.getText())) && (parametersAst = printAst.getFirstChild()) != null && (firstParameterAst = parametersAst.getFirstChild()) != null) {
                ast.setImaginary(true);
                outAst.setImaginary(true);
                printAst.setImaginary(true);
                parametersAst.setImaginary(true);
                this.updateASTLocations(firstParameterAst);
                Region region = firstParameterAst.getRegion();
                Region adjustedRegion = null;
                if ("prinx".equals(printAst.getText()) && firstParameterAst.getType() == 15) {
                    adjustedRegion = new Region(region.getStart().getLine(), region.getStart().getColumn() + 1, region.getEnd().getLine(), region.getEnd().getColumn() - 1);
                    firstParameterAst.setRegion(adjustedRegion);
                } else {
                    adjustedRegion = region;
                }
                for (AST imaginary : Arrays.asList(ast, outAst, printAst, parametersAst)) {
                    imaginary.setColumn(this.getTrace().getEglColumnNumberFor(imaginary.getLine(), imaginary.getColumn()));
                    imaginary.setLine(this.getTrace().getEglLineNumberFor(imaginary.getLine()));
                    imaginary.setImaginary(true);
                    imaginary.setExtraTokensHidden(true);
                    imaginary.setRegion(adjustedRegion);
                }
                if ("prinx".equals(printAst.getText()) && ("\\n".equals(firstParameterAst.getText()) || "\\r\\n".equals(firstParameterAst.getText()))) {
                    firstParameterAst.setImaginary(true);
                    firstParameterAst.setExtraTokensHidden(true);
                    Position adjustedEnd = new Position(firstParameterAst.getRegion().getStart().getLine(), firstParameterAst.getRegion().getStart().getColumn());
                    firstParameterAst.getRegion().setEnd(adjustedEnd);
                }
                return true;
            }
        }
        return false;
    }

    public void updateASTLocations(AST ast) {
        int eglStartColumn = this.getTrace().getEglColumnNumberFor(ast.getLine(), ast.getColumn());
        int eglEndColumn = this.getTrace().getEglColumnNumberFor(ast.getLine(), ast.getColumn() + ast.getLength());
        ast.setColumn(eglStartColumn);
        ast.setLength(Integer.valueOf(eglEndColumn - eglStartColumn));
        ast.setLine(this.getTrace().getEglLineNumberFor(ast.getLine()));
        for (Token token : ast.getExtraTokens()) {
            if (token == null) continue;
            token.setCharPositionInLine(this.getTrace().getEglColumnNumberFor(token.getLine(), token.getCharPositionInLine()));
            token.setLine(this.getTrace().getEglLineNumberFor(token.getLine()));
        }
        boolean done = this.updateRegionsOfStaticTextASTs(ast);
        ast.setRegion(null);
        if (!done) {
            for (AST child : ast.getChildren()) {
                this.updateASTLocations(child);
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$epsilon$egl$parse$EglToken$TokenType() {
        if ($SWITCH_TABLE$org$eclipse$epsilon$egl$parse$EglToken$TokenType != null) {
            return $SWITCH_TABLE$org$eclipse$epsilon$egl$parse$EglToken$TokenType;
        }
        int[] nArray = new int[EglToken.TokenType.values().length];
        try {
            nArray[EglToken.TokenType.END_COMMENT_TAG.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.END_OUTDENT_TAG.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.END_TAG.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.EOF.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.NEW_LINE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.PLAIN_TEXT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.PROGRAM.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.START_COMMENT_TAG.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.START_MARKER_TAG.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.START_OUTPUT_TAG.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EglToken.TokenType.START_TAG.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$epsilon$egl$parse$EglToken$TokenType = nArray;
        return nArray;
    }
}

