/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.preprocessor;

import com.google.common.collect.TreeBasedTable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.epsilon.egl.util.FileUtil;

public class PreprocessorTrace {
    private Map<Integer, Integer> lineNumberMapping = new TreeMap<Integer, Integer>();
    private TreeBasedTable<Integer, Integer, Integer> columnCorrections = TreeBasedTable.create();
    private int currentEolLine = 1;
    private int maximumEglLineNumber = 1;

    public int getEglLineNumberFor(int eolLine) {
        if (this.lineNumberMapping.containsKey(eolLine)) {
            return this.lineNumberMapping.get(eolLine);
        }
        return this.maximumEglLineNumber;
    }

    public int getEglColumnNumberFor(int eolLine, int eolCol) {
        SortedMap rowUpToColumn;
        if (this.columnCorrections.containsRow((Object)eolLine) && !(rowUpToColumn = this.columnCorrections.row((Object)eolLine).headMap(eolCol + 1)).isEmpty()) {
            int correction = (Integer)rowUpToColumn.get(rowUpToColumn.lastKey());
            return eolCol + correction;
        }
        return eolCol;
    }

    void setEglLineNumberForCurrentEolLineNumber(int eglLineNumber) {
        ++this.currentEolLine;
        this.lineNumberMapping.put(this.currentEolLine, eglLineNumber);
        this.maximumEglLineNumber = Math.max(this.maximumEglLineNumber, eglLineNumber);
    }

    void incrementColumnCorrectionNumber(int currentEolColumn, int correction) {
        if (this.columnCorrections.containsRow((Object)this.currentEolLine)) {
            SortedMap row = this.columnCorrections.row((Object)this.currentEolLine);
            Integer lastColumn = (Integer)row.lastKey();
            if (currentEolColumn < lastColumn) {
                throw new IllegalStateException(String.format("Tried to increment column correction number for EOL column %d, which is before the last EOL column number %d", currentEolColumn, lastColumn));
            }
            row.put(currentEolColumn, (Integer)row.get(lastColumn) + correction);
        } else {
            this.columnCorrections.row((Object)this.currentEolLine).put(currentEolColumn, correction);
        }
    }

    void reset() {
        this.lineNumberMapping.clear();
        this.columnCorrections.clear();
        this.currentEolLine = 0;
        this.maximumEglLineNumber = 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int eolLine = 1;
        while (eolLine <= this.currentEolLine) {
            builder.append(eolLine);
            builder.append(" -> ");
            builder.append(this.getEglLineNumberFor(eolLine));
            boolean bFirst = true;
            builder.append(" [");
            for (Map.Entry lineCorrection : this.columnCorrections.row((Object)eolLine).entrySet()) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    builder.append(", ");
                }
                builder.append(lineCorrection.getKey());
                builder.append(" -> ");
                builder.append(lineCorrection.getValue());
            }
            builder.append("]");
            builder.append(FileUtil.NEWLINE);
            ++eolLine;
        }
        return builder.toString();
    }
}

