/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.spec;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.incremental.IncrementalitySettings;
import org.eclipse.epsilon.egl.spec.CodeBackedTemplateSpecification;
import org.eclipse.epsilon.egl.spec.DirtyResourceBackedTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.ResourceBackedTemplateSpecification;
import org.eclipse.epsilon.eol.IImportManager;

public class EglTemplateSpecificationFactory {
    private final Formatter defaultFormatter;
    private final IncrementalitySettings incrementalitySettings;
    private final Collection<ITemplateExecutionListener> listeners;
    private final IImportManager importManager;

    public EglTemplateSpecificationFactory(Formatter defaultFormatter, IncrementalitySettings incrementalitySettings, IImportManager importManager, ITemplateExecutionListener ... listeners) {
        this.defaultFormatter = defaultFormatter;
        this.incrementalitySettings = incrementalitySettings;
        this.listeners = Arrays.asList(listeners);
        this.importManager = importManager;
    }

    public EglTemplateSpecification fromCode(String code) {
        return new CodeBackedTemplateSpecification(code, this.defaultFormatter, this.incrementalitySettings, this.importManager, this.listeners);
    }

    public EglTemplateSpecification fromResource(String name, URI resource) {
        return new ResourceBackedTemplateSpecification(name, resource, this.defaultFormatter, this.incrementalitySettings, this.importManager, this.listeners);
    }

    public EglTemplateSpecification fromDirtyResource(String name, String latestCode, URI resource) {
        return new DirtyResourceBackedTemplateSpecification(name, latestCode, resource, this.defaultFormatter, this.incrementalitySettings, this.importManager, this.listeners);
    }
}

